% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simVertexNonSmooth.R
\name{engineVertexNS}
\alias{engineVertexNS}
\title{Simulation Engine for dynamic Vertex case without smoothing of estimated predictor matrices.}
\usage{
engineVertexNS(
  InputNetwork,
  numSim,
  maxLag,
  VertexStatsvec = rep(1, nvertexstats),
  VertexLag = rep(1, maxLag),
  VertexLagMatrix = matrix(1, maxLag, length(VertexStatsvec)),
  VertexModelGroup = NA,
  VertexAttLag = rep(1, maxLag),
  dayClassObserved = NA,
  dayClassFuture = NA,
  EdgeModelTerms,
  EdgeModelFormula,
  EdgeGroup = NA,
  EdgeIntercept = c("edges"),
  EdgeNetparam = NA,
  EdgeExvar = NA,
  EdgeLag = rep(1, maxLag),
  EdgeLagMatrix = matrix(1, maxLag, length(EdgeModelTerms)),
  regMethod = "bayesglm",
  paramout = TRUE
)
}
\arguments{
\item{InputNetwork}{List of input networks}

\item{numSim}{number of time points to simulate}

\item{maxLag}{maximum Lag}

\item{VertexStatsvec}{Binary vector for vertex model.}

\item{VertexLag}{vector of lag for vertex}

\item{VertexLagMatrix}{matrix of lags for vertex stats.}

\item{VertexModelGroup}{Group term for vertex model.}

\item{VertexAttLag}{Lag vector for group term for vertex.}

\item{dayClassObserved}{Observed day class.}

\item{dayClassFuture}{Dayclass vector for future, must be of size numsim.}

\item{EdgeModelTerms}{Edge Model terms}

\item{EdgeModelFormula}{Edge model formula}

\item{EdgeGroup}{edge group term}

\item{EdgeIntercept}{edge intercept}

\item{EdgeNetparam}{edge network parameter name}

\item{EdgeExvar}{edge extraneous variable}

\item{EdgeLag}{edge Lag vector}

\item{EdgeLagMatrix}{edge lag matrix}

\item{regMethod}{regression method. "bayesglm" by default}

\item{paramout}{T/F on if regression needs to run.}
}
\value{
List with following elements:
SimNetwork: Output Networks \cr
EdgeParameterMat: Matrix of edge parameter \cr
VertexParameterMat: Matrix of Vertex parameters. \cr
}
\description{
Simulation engine for dynamic networks with variable number of vertices. 
Implements exponential family based hierarchical model for vertices and the edges. This does not 
implement smoothing for estimated predictor matrices.
}
\examples{
\dontrun{
nvertexstats <- 9
maxLag <- 3
VertexLag <- rep(1, maxLag)
VertexLagMatrix <- matrix(0, maxLag, nvertexstats)
VertexLagMatrix[, c(4, 7)] <- 1
VertexLagMatrix[c(2, 3), ] <- 1
simResult <- suppressWarnings(engineVertexNS(InputNetwork = beach,
                          numSim = 5,
                          maxLag = 3,
                          VertexStatsvec = rep(1, nvertexstats),
                          VertexModelGroup = "regular",
                          VertexAttLag = rep(1, maxLag),
                          VertexLag = rep(1, maxLag),
                          VertexLagMatrix = VertexLagMatrix,
                          EdgeModelTerms = NA,
                          EdgeModelFormula = NA,
                          EdgeGroup = NA,
                          EdgeIntercept = c("edges")
                          ))}
}
