% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{DerivLogf}
\alias{DerivLogf}
\alias{Deriv2Logf}
\title{Build Derivative Function for Log f}
\usage{
DerivLogf(f, parNames, preSimplify = T, ...)

Deriv2Logf(f, parNames, preSimplify = T, ...)
}
\arguments{
\item{f}{\code{function(y, theta, ...)}, where \code{theta} is a list of parameters.}

\item{parNames}{a vector of names or indices, the subset of parameters to use.}

\item{preSimplify}{simplify the body of \code{f} using functions from package \pkg{Deriv}.}

\item{...}{other arguments passed to \code{\link[Deriv]{Deriv}} from package \pkg{Deriv}.}
}
\value{
\code{DerivLogf} returns \code{function(y, theta, i, ...)} which evaluates to the first derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}.
The attribute \code{"d"} contains the list of sub functions.

\code{Deriv2Logf} returns \code{function(y, theta, i, j, ...)} which evaluates to the second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]} and \code{theta[[j]]}.
The attribute \code{"d2"} contains the list of sub functions.
}
\description{
\code{DerivLogf}/\code{Deriv2Logf} builds a function that evaluates to the first/second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}/\code{theta[[i]]} and \code{theta[[j]]}.
}
\details{
While \code{numDerivLogf} relies on the package \pkg{numDeriv} and therefore uses finite differences to evaluate the derivatives, \code{DerivLogf} utilizes the package \pkg{Deriv} to build sub functions for each parameter in \code{parNames}.
The same is true for \code{Deriv2Logf}.
}
\examples{
## see examples for param
## mind the gain regarding runtime compared to numDeriv

}
\seealso{
\pkg{Deriv}, \code{\link[Deriv]{Deriv}} in package \pkg{Deriv}, \code{\link{buildf}}, \code{\link{numDerivLogf}}, \code{\link{fisherI}}
}
