% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man.R
\name{man}
\alias{man}
\title{Display a Help Page From a File's Documentation}
\usage{
man(x, topic = NA, force_Rd = FALSE)
}
\arguments{
\item{x}{One of the following:
\itemize{
    \item A path to an R documentation (*.Rd) file.
    \item A path to a  code file containing comments for \pkg{roxygen2}.
    \item A  \code{\link{help}} topic if
    \code{options("document_package_directory")} is set (by
    \code{\link{document}}).
}}

\item{topic}{A \code{\link{help}} topic if \code{x} is a path to a code file
containing comments for \pkg{roxygen2}.}

\item{force_Rd}{if \code{x} is a file's path, then \code{\link{is_Rd_file}}
is used to decide whether the file is an R documentation file and call
\code{\link{document}} otherwise. Set to TRUE to disable this check and force
the file to be assumed to be an R documentation file.
\code{\link{is_Rd_file}} may produce false negatives.}
}
\value{
Invisibly the status of \code{\link{display_Rd}}.
}
\description{
Display a \code{\link[utils]{help}}-like page from an existing R
documentation (*.Rd) file, a topic from a temporary package with
\code{options("document_package_directory")} set or a topic from an R code
file containing \pkg{roxygen2} documentation.
}
\examples{
\donttest{
document::document(file_name = system.file("files", "minimal.R",
                   package = "document"), check_package = FALSE)
document::man("foo")
# this equivalent to
path <- system.file("files", "minimal.R", package = "document")
document::man(x = path, topic = "foo")
}
}
