% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plotTrees}
\alias{plotTrees}
\title{Plot a tree with colored internal node labels using ggtree}
\usage{
plotTrees(
  trees,
  nodes = FALSE,
  tips = NULL,
  tipsize = NULL,
  scale = 0.01,
  palette = "Dark2",
  base = FALSE,
  layout = "rectangular",
  node_nums = FALSE,
  tip_nums = FALSE,
  title = TRUE,
  labelsize = NULL,
  common_scale = FALSE,
  ambig = "grey",
  bootstrap_scores = FALSE,
  tip_palette = NULL,
  node_palette = NULL,
  guide_title = NULL,
  branch_lengths = NULL
)
}
\arguments{
\item{trees}{A tibble containing \code{phylo} and \code{airrClone}
objects}

\item{nodes}{color internal nodes if possible?}

\item{tips}{color tips if possible?}

\item{tipsize}{size of tip shape objects}

\item{scale}{width of branch length scale bar}

\item{palette}{color palette for tips and/or nodes. Can supply a named vector
for all tip states, or a palette named passed to
ggplot2::scale_color_brewer (e.g. "Dark2", "Paired", "Set1") or
ggplot2::scale_color_distiller (e.g. RdYlBu) or}

\item{base}{recursion base case (don't edit)}

\item{layout}{rectangular or circular tree layout?}

\item{node_nums}{plot internal node numbers?}

\item{tip_nums}{plot tip numbers?}

\item{title}{use clone id as title?}

\item{labelsize}{text size}

\item{common_scale}{stretch plots so branches are on same scale?
determined by sequence with highest divergence}

\item{ambig}{How to color ambiguous node reconstructions? (grey or blend)}

\item{bootstrap_scores}{Show bootstrap scores for internal nodes? See getBootstraps.}

\item{tip_palette}{deprecated, use palette}

\item{node_palette}{deprecated, use palette}

\item{guide_title}{Title of color guide. Defaults to tips variable if specified.}

\item{branch_lengths}{Use branch lenghts? Use "none" if not.}
}
\value{
a grob containing a tree plotted by \code{ggtree}.
}
\description{
\code{plotTrees} plots a tree or group of trees
}
\details{
Function uses \code{ggtree} functions to plot tree topologies estimated by 
\link{getTrees}, and \link{findSwitches}. Object can be further modified with 
\code{ggtree} functions. Please check out 
https://bioconductor.org/packages/devel/bioc/vignettes/ggtree/inst/doc/ggtree.html and
cite \code{ggtree} in addition to \code{dowser} if you use this function.
}
\examples{
data(ExampleClones)
trees <- getTrees(ExampleClones[10,])
plotTrees(trees)[[1]]
}
\seealso{
\link{getTrees}, \link{findSwitches}
}
