% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressions.R
\name{Areg}
\alias{Areg}
\title{Internal Aalen's Additive Hazards Model storing a linear effect estimate for each event time}
\usage{
Areg(out.formula, id, data, method, ...)
}
\arguments{
\item{out.formula}{Survival formula for Aalen's additive hazards model.}

\item{id}{character string indicating which column of 'data' corresponds to the subject ID.}

\item{data}{Data set in counting process format. In particular the data should contain a "start", "stop" and "event" column along with
any mediators and baseline covariates.}

\item{method}{passed from dpa call, defaults to "timereg", otherwise "aareg"}

\item{...}{other parameters passed to Aalen's additive hazards regression function "timereg::aalen()"}
}
\value{
data.frame with observation times and estimated coefficients for independent variables in "regformula"
}
\description{
Do not call this function on its own
}
\examples{
library(dpasurv)

data(simdata)

obj <- Areg(Surv(start,stop,event)~M+x, id="subject", data=simdata, method="timereg")

}
\keyword{internal}
