% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressions.R
\name{Mreg}
\alias{Mreg}
\title{Internal mediator regression function storing a linear regression estimate for each event time}
\usage{
Mreg(regformula, obstimes, startt, stopt, event, mediator, dataset, w = 1)
}
\arguments{
\item{regformula}{independent variable input as for standard lm fuction in R}

\item{obstimes}{observed event times at which Aalen's additive model is estimated via the function Areg}

\item{startt}{start time of the observation intervals}

\item{stopt}{end time of the observation intervals (actual event times)}

\item{event}{event indicator}

\item{mediator}{mediator of interest}

\item{dataset}{dataset (in counting process format)}

\item{w}{(optional) weights (not actually used in the default implementation of dynamic path analysis, set to 1)}
}
\value{
data.frame with observation times and estimated coefficients for independent variables in "regformula"
}
\description{
Do not call this function on its own
}
\examples{
library(dpasurv)

data(simdata)

obj <- Mreg(~x, sort(simdata$stop[simdata$event==1]), "start", "stop", "event", "M", simdata)

}
\keyword{internal}
