% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_or_table.R
\name{do_or_table}
\alias{do_or_table}
\title{Dropout Odds Ratio Table}
\usage{
do_or_table(do_stats, chisq_question, sel_cond_chisq)
}
\arguments{
\item{do_stats}{data.frame statistics table as computed by \code{\link[=compute_stats]{compute_stats()}}.}

\item{chisq_question}{numeric Which question to calculate the OR table for}

\item{sel_cond_chisq}{character vector naming the experimental conditions to compare}
}
\value{
Returns a Matrix containing the Odds Ratios of dropout between all selected conditions.
}
\description{
This function calculates an Odds Ratio table at a given question for selected experimental
conditions. It needs data in the format as created by \code{\link[=compute_stats]{compute_stats()}} as input.
}
\examples{
do_stats <- compute_stats(df = add_dropout_idx(dropRdemo, 3:54),
by_cond = "experimental_condition",
no_of_vars = 52)

do_or_table(do_stats, chisq_question = 51, sel_cond_chisq = c("11", "12", "21", "22"))


}
\seealso{
\code{\link[=compute_stats]{compute_stats()}}
}
