% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_bias.R
\name{EPsProg_bias}
\alias{EPsProg_bias}
\alias{EPsProg_L}
\alias{EPsProg_L2}
\alias{EPsProg_R}
\alias{EPsProg_R2}
\title{Expected probability of a successful program for bias adjustment programs with time-to-event outcomes}
\usage{
EPsProg_L(
  HRgo,
  d2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  hr1,
  hr2,
  id1,
  id2,
  fixed
)

EPsProg_L2(
  HRgo,
  d2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  hr1,
  hr2,
  id1,
  id2,
  fixed
)

EPsProg_R(
  HRgo,
  d2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  hr1,
  hr2,
  id1,
  id2,
  fixed
)

EPsProg_R2(
  HRgo,
  d2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  hr1,
  hr2,
  id1,
  id2,
  fixed
)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total events for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{EPsProg_L()}, \code{EPsProg_L2()}, \code{EPsProg_R()} and \code{EPsProg_R2()} is the expected probability of a successful program.
}
\description{
To discount for overoptimistic results in phase II when calculating the optimal sample size in phase III,
it is necessary to use the following functions, which each describe a specific case:
\itemize{
\item \code{EPsProg_L()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_L2()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval)
when the go-decision is also affected by the bias adjustment
\item \code{EPsProg_R()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_R2()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor)
when the go-decision is also affected by the bias adjustment
}
}
\examples{
res <- EPsProg_L(HRgo = 0.8, d2 = 50, Adj = 0.4, 
                           alpha = 0.025, beta = 0.1, 
                           step1 = 1, step2 = 0.95, 
                           w = 0.3, hr1 = 0.69, hr2 = 0.81,
                           id1 = 280, id2 = 420, fixed = FALSE)
          res <- EPsProg_L2(HRgo = 0.8, d2 = 50, Adj = 0.4, 
                           alpha = 0.025, beta = 0.1, 
                           step1 = 1, step2 = 0.95, 
                           w = 0.3, hr1 = 0.69, hr2 = 0.81,
                           id1 = 280, id2 = 420, fixed = FALSE)
          res <- EPsProg_R(HRgo = 0.8, d2 = 50, Adj = 0.9, 
                           alpha = 0.025, beta = 0.1, 
                           step1 = 1, step2 = 0.95, 
                           w = 0.3, hr1 = 0.69, hr2 = 0.81,
                           id1 = 280, id2 = 420, fixed = FALSE)
          res <- EPsProg_R2(HRgo = 0.8, d2 = 50, Adj = 0.9, 
                           alpha = 0.025, beta = 0.1, 
                           step1 = 1, step2 = 0.95, 
                           w = 0.3, hr1 = 0.69, hr2 = 0.81,
                           id1 = 280, id2 = 420, fixed = FALSE)
}
\keyword{internal}
