% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_tte.R
\name{EPsProg_multiple_tte}
\alias{EPsProg_multiple_tte}
\title{Expected probability of a successful program for multiple endpoints in a time-to-event setting}
\usage{
EPsProg_multiple_tte(
  HRgo,
  n2,
  alpha,
  beta,
  ec,
  hr1,
  hr2,
  id1,
  id2,
  step1,
  step2,
  fixed,
  rho,
  rsamp
)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule;}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{ec}{control arm event rate for phase II and III}

\item{hr1}{assumed true treatment effect on HR scale for endpoint OS}

\item{hr2}{assumed true treatment effect on HR scale for endpoint PFS}

\item{id1}{amount of information for \code{hr1} in terms of sample size}

\item{id2}{amount of information for \code{hr2} in terms of sample size}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{fixed}{choose if true treatment effects are fixed or random}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
The output of the function \code{EPsProg_multiple_tte()} is the expected probability of a successful program, when going to phase III.
}
\description{
This function calculates the probability that our drug development program is successful.
Successful is defined as at least one endpoint showing a statistically significant positive treatment effect in phase III.
}
\keyword{internal}
