% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_normal.R
\name{optimal_normal}
\alias{optimal_normal}
\title{Optimal phase II/III drug development planning with normally distributed endpoint}
\usage{
optimal_normal(
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  n2min,
  n2max,
  stepn2,
  kappamin,
  kappamax,
  stepkappa,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 0,
  stepm1 = 0.5,
  stepl1 = 0.8,
  b1,
  b2,
  b3,
  gamma = 0,
  fixed = FALSE,
  skipII = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for
\href{https://web.imbi.uni-heidelberg.de/prior/}{mixture prior distribution}}

\item{Delta1}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{Delta2}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{in1}{amount of information for \code{Delta1} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in2}{amount of information for \code{Delta2} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{a}{lower boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{b}{upper boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{n2min}{minimal total sample size for phase II; must be an even number}

\item{n2max}{maximal total sample size for phase II, must be an even number}

\item{stepn2}{step size for the optimization over n2; must be an even number}

\item{kappamin}{minimal threshold value kappa for the go/no-go decision rule}

\item{kappamax}{maximal threshold value  kappa for the go/no-go decision rule}

\item{stepkappa}{step size for the optimization over the threshold value kappa}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the sample size for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small", default: 0}

\item{stepm1}{lower boundary for effect size category "medium" = upper boundary for effect size category "small" default: 0.5}

\item{stepl1}{lower boundary for effect size category "large" = upper boundary for effect size category "medium", default: 0.8}

\item{b1}{expected gain for effect size category "small" in 10^5 $}

\item{b2}{expected gain for effect size category "medium" in 10^5 $}

\item{b3}{expected gain for effect size category "large" in 10^5 $}

\item{gamma}{to model different populations in phase II and III choose \code{gamma != 0}, default: 0, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{fixed}{choose if true treatment effects are fixed or following a prior distribution, if TRUE \code{Delta1} is used as fixed effect}

\item{skipII}{choose if skipping phase II is an option, default: FALSE;
if TRUE, the program calculates the expected utility for the case when phase
II is skipped and compares it to the situation when phase II is not skipped.
The results are then returned as a two-row data frame, \code{res[1, ]}
being the results when including phase II and \code{res[2, ]} when skipping phase II.
\code{res[2, ]} has an additional parameter, \code{res[2, ]$median_prior_Delta}, which is
the assumed effect size used for planning the phase III study when the
phase II is skipped.}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function \code{\link{optimal_normal}} is a data.frame containing the optimization results:
\describe{
\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}
\item{Kappa}{optimal threshold value for the decision rule to go to phase III}
\item{n2}{total sample size for phase II}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}
\item{sProg1}{probability of a successful program with "small" treatment effect in phase III}
\item{sProg2}{probability of a successful program with "medium" treatment effect in phase III}
\item{sProg3}{probability of a successful program with "large" treatment effect in phase III }
\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}
}
and further input parameters.

Taking \code{cat(comment())} of the data.frame object lists the used optimization
sequences, start and finish date of the optimization procedure. Taking
\code{attr(,"trace")} returns the utility values of all parameter combinations
visited during optimization
}
\description{
The function \code{\link{optimal_normal}} of the \code{\link{drugdevelopR}}
package enables planning of phase II/III drug development programs with
optimal sample size allocation and go/no-go decision rules for normally
distributed endpoints. The treatment effect is measured by the standardized
difference in means. The assumed true treatment effects can be assumed to be
fixed or modelled by a prior distribution. The R Shiny application
\href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the prior
distributions used in this package. Fast computing is enabled by parallel
programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_normal(w=0.3,                       # define parameters for prior
  Delta1 = 0.375, Delta2 = 0.625, in1=300, in2=600,  # (https://web.imbi.uni-heidelberg.de/prior/)
  a = 0.25, b = 0.75,
  n2min = 20, n2max = 100, stepn2 = 4,               # define optimization set for n2
  kappamin = 0.02, kappamax = 0.2, stepkappa = 0.02, # define optimization set for kappa
  alpha = 0.025, beta = 0.1,                          # drug development planning parameters
  c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,         # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                        # set constraints
  steps1 = 0,                                        # define lower boundary for "small"
  stepm1 = 0.5,                                      # "medium"
  stepl1 = 0.8,                                      # and "large" effect size categories
  b1 = 3000, b2 = 8000, b3 = 10000,                  # benefit for each effect size category
  gamma = 0,                                         # population structures in phase II/III
  fixed = FALSE,                                     # true treatment effects are fixed/random
  skipII = FALSE,                                    # skipping phase II
  num_cl = 1)                                        # number of cores for parallelized computing
}
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences.
}
