% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{close_small_gaps}
\alias{close_small_gaps}
\title{Close small gaps between successive prescriptions}
\usage{
close_small_gaps(data, min_gap = 0L)
}
\arguments{
\item{data}{A data frame containing columns \code{prodcode}, \code{patid},
\code{start_date} and \code{stop_date}}

\item{min_gap}{Size of largest gaps to close. Default is zero, i.e. do nothing}
}
\value{
The input data frame \code{data}, possibly with some of the
\code{stop_date}s changed.
}
\description{
Given a series of prescriptions in \code{data}, if one prescription
(for the same patient and drug) starts \eqn{\leq} \code{min_gap} days
after the previous one finishes, we extend the length of the previous
prescription to cover the gap.
}
\examples{
gappy_data <- data.frame(
  patid = 1,
  prodcode = 'a',
  start_date = Sys.Date() + (0:6) * 7,
  stop_date = Sys.Date() + (0:6) * 7 + 4
)
close_small_gaps(gappy_data)
close_small_gaps(gappy_data, 7)

}
