% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{decision_9}
\alias{decision_9}
\title{Decision 9: handle overlapping prescription periods}
\usage{
decision_9(data, decision = "a")
}
\arguments{
\item{data}{a data frame}

\item{decision}{one of the following strings:
\describe{
\item{"a"}{allow overlapping prescriptions (implicitly sum doses)}
\item{"b"}{move later prescription to next available time that this product is not prescribed}
}}
}
\description{
In situations where one prescription starts before another (for the same
patient and drug) finishes, this function will either implicitly sum the
doses (i.e. do nothing) or it will divide the intervals into non-overlapping
subsets, shifting these sub-intervals forward in time until there is no
overlap.
}
\details{
The underlying algorithm for shifting overlapping intervals is implemented
by the internal function \code{shift_interval}.
}
\seealso{
Other decision functions: 
\code{\link{decision_10}()},
\code{\link{decision_1}()},
\code{\link{decision_2}()},
\code{\link{decision_3}()},
\code{\link{decision_4}()},
\code{\link{decision_5}()},
\code{\link{decision_6}()},
\code{\link{decision_7}()},
\code{\link{decision_8}()},
\code{\link{drug_prep}()}
}
\concept{decision functions}
