% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{func.gaussmodel}
\alias{func.gaussmodel}
\title{Return the evaluation of a vector with Gaussian-based model}
\usage{
\method{func}{gaussmodel}(model, x, cdf = FALSE, n = 1, scaling = FALSE, ...)
}
\arguments{
\item{model}{\code{gaussmodel} object.}

\item{x}{A numeric vector to be evaluated with a distribution.}

\item{cdf}{A logical scalar whether the evaluation is done with a cumulative
distribution or not. A default value is \code{FALSE}, which means that the
evaluation is done with a density.}

\item{n}{The index indicates the estimates. 1, by default, is the best
estimate, and 2 is the 2nd best, etc.}

\item{scaling}{A logical scalar, which indicates whether or not it scales
means and standard deviations in \code{mulist} and \code{sdlist}.
The default value is \code{FALSE}.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A numeric vector of the evaluatio of input vector \code{x} with a model.
}
\description{
Evaluate an input vector \code{x} with Gaussian-based model and
return its vector.
By default, it evaluate with the best model and its density, but
it can designate the model by index and also can evaluate with a cumulative
distribution.
}
\examples{
## Create an `gaussmodel` object
gmodel <- gaussmodel(mix2gauss$n200)
## Estimate an model with parameters
gmodel <- estimate(gmodel, deglist=4, mulist=0.15, sdlist=0.73)
## A vector for input
x <- seq(-4, 4, by=0.1)
## Density function
y <- func(gmodel, x)
## Cumulative distribution
y <- func(gmodel, x, cdf=TRUE)
}
\seealso{
\code{\link[=gaussmodel]{gaussmodel()}} \code{\link[=summary.gaussmodel]{summary.gaussmodel()}} \code{\link[=plot.gaussmodel]{plot.gaussmodel()}}
\code{\link[=estimate.gaussmodel]{estimate.gaussmodel()}} \code{\link[=pdf_gaussmodel]{pdf_gaussmodel()}} \code{\link[=cdf_gaussmodel]{cdf_gaussmodel()}}
}
