% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleBTF_reg_backfit}
\alias{sampleBTF_reg_backfit}
\title{(Backfitting) Sampler for first or second order random walk (RW) Gaussian dynamic linear model (DLM)}
\usage{
sampleBTF_reg_backfit(y, X, beta, obs_sigma_t2, evol_sigma_t2, D = 1)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{X}{the \code{T x p} matrix of time series predictors}

\item{beta}{the \code{T x p} matrix of previous dynamic regression coefficients}

\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x p} matrix of evolution error variances}

\item{D}{the degree of differencing (one or two)}
}
\value{
\code{T x p} matrix of simulated dynamic regression coefficients \code{beta}
}
\description{
Compute one draw of the \code{T x p} state variable \code{beta} in a DLM using back-band substitution methods.
This model is equivalent to the Bayesian trend filtering (BTF) model applied to \code{p}
dynamic regression coefficients corresponding to the design matrix \code{X},
assuming appropriate (shrinkage/sparsity) priors for the evolution errors. The sampler
here uses a backfitting method that draws each predictor j=1,...,p conditional on the
other predictors (and coefficients), which leads to a faster \code{O(Tp)} algorithm.
However, the MCMC may be less efficient.
}
\note{
Missing entries (NAs) are not permitted in \code{y}. Imputation schemes are available.
}
