% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linComb.R
\name{helper_TS}
\alias{helper_TS}
\title{Helper function for TS method.}
\usage{
helper_TS(theta, markers, status)
}
\arguments{
\item{theta}{a \code{numeric} parameter that will be estimated in TS
method for the combination score}

\item{markers}{a \code{numeric} data frame that contains the biomarkers}

\item{status}{a \code{factor} data frame that includes the actual disease
status of the patients}
}
\value{
A \code{numeric} Optimized value calculated with combination scores
using theta
}
\description{
The \code{helper_TS} function calculates the combination
coefficient and optimized value of given biomarkers for the TS method.
}
\examples{
# call data
data(laparotomy)

# define the function parameters
markers <- cbind(laparotomy$ddimer, laparotomy$log_leukocyte)
status <- factor(laparotomy$group, levels = c("not_needed", "needed"))

t <- 0.5

stat <- helper_TS(theta = t, markers = markers, status = status)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
