% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinComb.R
\name{nonlinComb}
\alias{nonlinComb}
\title{Combine two diagnostic tests with several non-linear combination methods.}
\usage{
nonlinComb(
  markers = NULL,
  status = NULL,
  event = NULL,
  method = c("polyreg", "ridgereg", "lassoreg", "elasticreg", "splines", "sgam", "nsgam"),
  degree1 = 3,
  degree2 = 3,
  df1 = 4,
  df2 = 4,
  resample = c("none", "cv", "repeatedcv", "boot"),
  nfolds = 5,
  nrepeats = 3,
  niters = 10,
  standardize = c("none", "min_max_scale", "zScore", "tScore", "scale_mean_to_one",
    "scale_sd_to_one"),
  include.interact = FALSE,
  alpha = 0.5,
  show.plot = TRUE,
  direction = c("auto", "<", ">"),
  conf.level = 0.95,
  cutoff.method = c("CB", "MCT", "MinValueSp", "MinValueSe", "ValueSp", "ValueSe",
    "MinValueSpSe", "MaxSp", "MaxSe", "MaxSpSe", "MaxProdSpSe", "ROC01", "SpEqualSe",
    "Youden", "MaxEfficiency", "Minimax", "MaxDOR", "MaxKappa", "MinValueNPV",
    "MinValuePPV", "ValueNPV", "ValuePPV", "MinValueNPVPPV", "PROC01", "NPVEqualPPV",
    "MaxNPVPPV", "MaxSumNPVPPV", "MaxProdNPVPPV", "ValueDLR.Negative",
    "ValueDLR.Positive", "MinPvalue", "ObservedPrev", "MeanPrev", "PrevalenceMatching"),
  show.result = FALSE,
  ...
)
}
\arguments{
\item{markers}{a \code{numeric} data frame that includes two diagnostic tests
results}

\item{status}{a \code{factor} vector that includes the actual disease
status of the patients}

\item{event}{a \code{character} string that indicates the event in the status
to be considered as positive event}

\item{method}{a \code{character} string specifying the method used for
combining the markers. The available methods are:
\itemize{
\item \bold{Logistic Regression with Polynomial Feature Space} \code{(polyreg)}:  The method
builds a logistic regression model with the polynomial feature space and returns the probability
of a positive event for each observation.
\item \bold{Ridge Regression with Polynomial Feature Space} \code{(ridgereg)}: Ridge regression is a
shrinkage method used to estimate the coefficients of highly correlated variables and in this case
the polynomial feature space created from two markers. For the implementation of the method,
glmnet() library is used with two functions: cv.glmnet() to run a cross
validation model to determine the tuning parameter \eqn{\lambda} and glmnet() to fit the
model with the selected tuning parameter. For Ridge regression,
the glmnet() package is integrated into the dtComb package to facilitate the implementation
of this method.
\item \bold{Lasso Regression with Polynomial Feature Space} \code{(lassoreg)}: Lasso regression,
like Ridge regression, is a type of shrinkage method. However, a notable difference is that
Lasso tends to set some feature coefficients to zero, making it useful for feature elimination.
It also employs cross-validation for parameter selection and model fitting using the glmnet library.
\item \bold{Elastic Net Regression with Polynomial Feature Space} \code{(elasticreg)}: Elastic Net
regression is a hybrid model that merges the penalties from Ridge and Lasso regression, aiming
to leverage the strengths of both approaches. This model involves two parameters: \eqn{\lambda},
similar to Ridge and Lasso, and \eqn{\alpha}, a user-defined mixing parameter ranging between 0 (representing Ridge)
and 1 (representing Lasso). The \eqn{\alpha} parameter determines the balance or weights between the loss functions
of Ridge and Lasso regressions.
\item \bold{Splines} \code{(splines)}: Another non-linear approach to combine markers
involves employing regression models within a polynomial feature space. This approach
applies multiple regression models to the dataset using a function derived from
piecewise polynomials. This implementation uses splines with user-defined degrees
of freedom and degrees for the fitted polynomials. The splines library
is employed to construct piecewise logistic regression models using base splines.
\item \bold{Generalized Additive Models with Smoothing Splines and Generalized Additive Models
with Natural Cubic Splines} \code{(sgam & nsgam)}: In addition to the basic spline structure,
Generalized Additive Models are applied with natural cubic splines and smoothing splines
using the gam library in R.
}}

\item{degree1}{a \code{numeric} value for polynomial based methods indicates
the degree of the feature space created for marker 1, for spline based
methods the degree of the fitted polynomial between each node for marker 1.
(3, default)}

\item{degree2}{a \code{numeric} value for polynomial based methods indicates
the degree of the feature space created for marker 2, for spline based
methods the degree of the fitted polynomial between each node for marker 2
(3, default)}

\item{df1}{a \code{numeric} value that indicates the number of knots as the
degrees of freedom in spline based methods for marker 1 (4, default)}

\item{df2}{a \code{numeric} value that indicates the number of knots as the
degrees of freedom in spline based methods for marker 2 (4, default)}

\item{resample}{a \code{character} string indicating the name of the
resampling options. Bootstrapping Cross-validation and repeated cross-validation
are given as the options for resampling, along with the number
of folds and number of repeats.
\itemize{
\item \code{boot}: Bootstrapping is performed similarly; the dataset
is divided into folds with replacement and models are trained and tested
in these folds to determine the best parameters for the given method and
dataset.
\item \code{cv}: Cross-validation resampling, the dataset is divided into the
number of folds given without replacement; in each iteration, one fold is
selected as the test set, and the model is built using the remaining folds
and tested on the test set. The corresponding AUC values and the parameters
used for the combination are kept in a list. The best-performed model is
selected, and the combination score is returned for the whole dataset.
\item \code{repeatedcv}: Repeated cross-validation the process is repeated,
and the best-performed models selected at each step are stored in another
list; the best performed among these models is selected to be applied to
the entire dataset.
}}

\item{nfolds}{a \code{numeric} value that indicates the number of folds for
cross validation based resampling methods  (5, default)}

\item{nrepeats}{a \code{numeric} value that indicates the number of repeats
for "repeatedcv" option of resampling methods (3, default)}

\item{niters}{a \code{numeric} value that indicates the number of
bootstrapped resampling iterations (10, default)}

\item{standardize}{a \code{character} string indicating the name of the
standardization method. The default option is no standardization applied.
Available options are:
\itemize{
\item \bold{Z-score} \code{(zScore)}: This method scales the data to have a mean
of 0 and a standard deviation of 1. It subtracts the mean and divides by the standard
deviation for each feature. Mathematically,
\deqn{ Z-score = \frac{x - (\overline x)}{sd(x)}}

where \eqn{x} is the value of a marker, \eqn{\overline{x}} is the mean of the marker and \eqn{sd(x)} is the standard deviation of the marker.
\item \bold{T-score} \code{(tScore)}: T-score is commonly used
in data analysis to transform raw scores into a standardized form.
The standard formula for converting a raw score \eqn{x} into a T-score is:
\deqn{T-score = \Biggl(\frac{x - (\overline x)}{sd(x)}\times 10 \Biggl) +50}
where \eqn{x} is the value of a marker, \eqn{\overline{x}} is the mean of the marker
and \eqn{sd(x)} is the standard deviation of the marker.

\item \bold{min_max_scale} \code{(min_max_scale)}: This method transforms data to
a specific scale, between 0 and 1. The formula for this method is:
\deqn{min_max_scale = \frac{x - min(x)}{max(x) - min(x)}}

\item \bold{scale_mean_to_one} \code{(scale_mean_to_one)}: This method scales
the arithmetic mean to 1. The formula for this method is:
\deqn{scale_mean_to_one =  \frac{x}{\overline{x}}}
where \eqn{x} is the value of a marker and \eqn{\overline{x}} is the mean of the marker.

\item \bold{scale_sd_to_one} \code{(scale_sd_to_one)}: This method, which allows for
comparison of individual data points in relation to the overall spread of
the data, scales the standard deviation to 1. The formula for this method is:
\deqn{scale_sd_to_one = \frac{x}{sd(x)}}
where \eqn{x} is the value of a marker and \eqn{sd(x)} is the standard deviation of the marker.
}}

\item{include.interact}{a \code{logical} indicator that specifies whether to
include the interaction between the markers to the feature space created for
polynomial based methods (FALSE, default)}

\item{alpha}{a \code{numeric} value as the mixing parameter in Elastic Net
Regression method (0.5, default)}

\item{show.plot}{a \code{logical}. If TRUE, a ROC curve is
plotted. Default is TRUE}

\item{direction}{a \code{character} string determines in which direction the
comparison will be made.  ">": if the predictor values for the control group
are higher than the values of the case group (controls > cases).
"<": if the predictor values for the control group are lower or equal than
the values of the case group (controls < cases).}

\item{conf.level}{a \code{numeric} values determines the confidence interval
for the ROC curve(0.95, default).}

\item{cutoff.method}{a \code{character} string determines the cutoff method
for the ROC curve.}

\item{show.result}{a \code{logical} string indicating whether the results
should be printed to the console.}

\item{\dots}{further arguments. Currently has no effect on the results.}
}
\value{
A list of \code{numeric} nonlinear combination scores calculated
according to the given method and standardization option
}
\description{
The \code{nonlinComb} function calculates the combination
scores of two diagnostic tests selected among several non-linear combination
methods and standardization options
}
\examples{
data("laparotomy")
data <- laparotomy

markers <- data[, -1]
status <- factor(data$group, levels = c("not_needed", "needed"))
event <- "needed"
cutoff.method <- "Youden"

score1 <- nonlinComb(
  markers = markers, status = status, event = event,
  method = "lassoreg", include.interact = FALSE, resample = "boot", niters = 5,
  degree1 = 4, degree2 = 4, cutoff.method = cutoff.method,
  direction = "<"
)

score2 <- nonlinComb(
  markers = markers, status = status, event = event,
  method = "splines", resample = "none", cutoff.method = cutoff.method,
  standardize = "tScore", direction = "<"
)

score3 <- nonlinComb(
  markers = markers, status = status, event = event,
  method = "lassoreg", resample = "repeatedcv", include.interact = TRUE,
  cutoff.method = "ROC01", standardize = "zScore", direction = "auto"
)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
