% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{\%<<-\%}
\alias{\%<<-\%}
\alias{\%->>\%}
\title{Assign nested components of a list to names}
\usage{
pattern \%<<-\% value

value \%->>\% pattern
}
\arguments{
\item{pattern}{Pattern of names that the components of \code{value} are assigned
to (see below).}

\item{value}{List or vector.}
}
\value{
Returns \code{value} invisibly.
}
\description{
The \code{\%<<-\%} operator assigns multiple (nested) components of a list or vector
to names via pattern matching (“unpacking assignment”). Think of the
“dub(ble) arrow” \code{<<-} as a pictograph representing multiple \code{<-}'s.

\code{\%<<-\%} is especially convenient for:
\itemize{
\item assigning individual names to the multiple values that a function may
return in the form of a list;
\item extracting deeply nested list components.
}
}
\section{Pattern-matching names}{
 Names are matched to the (nested) components
of a list using a concise pattern matching syntax that mirrors the
structure of the list. Apart from names, the syntax consists of two classes
of symbols:
\itemize{
\item \strong{List constructors} — Use a pair of parentheses to indicate a list, and
a colon, rather than a comma, to indicate successive names.
\item \strong{Wildcards} — Use a dot (\code{.}) to skip assignment of a specific
component, or dots (\code{...}) to skip assignment of a range of components.
}

See the examples for an illustration of common use cases.
}

\section{Prior art}{
 Unpacking/multiple assignment appears in other
languages (e.g.,
\href{https://docs.python.org/3/tutorial/datastructures.html#tuples-and-sequences}{Python},
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment}{JavaScript},
\href{https://clojure.org/guides/destructuring}{Clojure}).
While R has no such feature, using a custom operator to do this has long
been a folklore method. An early implementation is due to
\href{https://stat.ethz.ch/pipermail/r-help/2004-June/053343.html}{Gabor Grothendieck}
(2004), cf. \code{list} in the
\href{https://cran.r-project.org/package=gsubfn}{gsubfn} package.
}

\examples{
# Assign successive components
(one : two : three) \%<<-\% list(1, 2, 3)
stopifnot(one == 1, two == 2, three == 3)

# Assign nested components
(p : (q : r : (s : t))) \%<<-\% list(1, list(2, 3, list(4, 5)))
(P : (Q : R : S)) \%<<-\% list(1, list(2, 3, list(4, 5)))
stopifnot(p == 1, q == 2, r == 3, s == 4, t == 5,
          P == 1, Q == 2, R == 3, identical(S, list(4, 5)))

# Unpack nested components with nested parentheses
(w) \%<<-\% list(1:3)
(((z))) \%<<-\% list(list(list("z")))
((x : y)) \%<<-\% list(list("x", "y"))
stopifnot(w == 1:3, x == "x", y == "y", z == "z")

# Skip a component with a dot (.)
(a : . : b) \%<<-\% list("a", "skip this", "b")
((c : .) : .) \%<<-\% list(list("c", "skip this"), "skip this")
stopifnot(a == "a", b == "b", c == "c")

# Skip a range of components with dots (...)
(first : ... : last) \%<<-\% letters
(. : second : ...) \%<<-\% letters
(mpg : cyl : ...) \%<<-\% mtcars
stopifnot(
  first == "a", second == "b", last == "z",
  mpg == mtcars$mpg, cyl == mtcars$cyl
)

}
