% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_chaos.r
\name{find_chaos}
\alias{find_chaos}
\title{Find chaotic motions in the data.}
\usage{
find_chaos(data, window_length, skip_window, skip_test01 = 1,
  test01_thresh = 0.05, find_thresh = 20)
}
\arguments{
\item{data}{Analyzed data.}

\item{window_length}{Length of the window for in which the 0-1 test for chaos will be computed.}

\item{skip_window}{Length of the skip of the window moving in the data.}

\item{skip_test01}{Length of the skip to take data for calculation the 0-1 test for chaos in the window.}

\item{test01_thresh}{The threshold to decide about motion.}

\item{find_thresh}{Precision of found intervals.}
}
\value{
The list of optimized chaotic motion borders.
}
\description{
Find chaotic motions in the data.
}
\examples{
# Calculate the logistic map.
cons <- 0.5
data.len <- 17000
chaos.start <- c(5536, 9768)
vec.x <- matrix(cons, data.len, 1)

vec.x[1] <- (2^0.5)/2
for (i in 2:data.len){
  # x_n+1 = r*x_n(1-x_n)
  vec.x[i] <- 3.7*vec.x[i-1]*(1-vec.x[i-1])
}
vec.x[1:(chaos.start[1]-1)] <-cons
vec.x[(chaos.start[2]+1):data.len] <-cons
tr1 <- seq(from = cons, to = vec.x[chaos.start[1]], length.out = 2001)
tr2 <- seq(from = vec.x[chaos.start[2]], to = cons, length.out = 2001)
vec.x[(chaos.start[1]-2000):chaos.start[1]] <- tr1
vec.x[chaos.start[2]:(chaos.start[2]+2000)] <- tr2

# Find chaotic intervals in vec.x and plot results.
chaotic_borders <- find_chaos(vec.x, "skip_window" = 1000,
  "window_length" = 3000, "find_thresh" = 300)
}
