% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.R
\name{volume}
\alias{volume}
\title{Volume between two height levels.}
\usage{
volume(h1, h2, H, D, b, bh, rhd)
}
\arguments{
\item{h1, h2}{The two height levels.}

\item{H}{Tree total height.}

\item{D}{Tree diameter at breast height.}

\item{b}{Vector with the 5 parameters.}

\item{bh}{Breast height. Typically 1.2, 1.3 or 1.4 m, or 4.5 ft.}

\item{rhd}{Ratio between the height and diameter units. E.g., 100
for m and cm, or 12 for feet and inches.}
}
\value{
Volume between \code{h1} and \code{h2}.
}
\description{
Volume between two height levels.
}
\examples{
   b <- c(2.569, 0, 1.042, 0.3012, -1)  # parameters
   Dib <- 0.956 * 24  # convert dbh outside bark to inside bark 
   volume(0, 32, 32, Dib, b, 1.3, 100)  # total volume
   h15 <- hlevel(15, 32, Dib, b, 1.3)  # height for diameter 15
   volume(0.3, h15, 32, Dib, b, 1.3, 100)  # volume between stump and h15

}
