% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animateCV.R
\name{animateCV}
\alias{animateCV}
\title{Animate Cyclic Voltammetry Simulation}
\usage{
animateCV(filename, out_type = c("html", "gif"), out_name = "aniCV")
}
\arguments{
\item{filename}{Name of the file that contains the results of a cyclic voltammetry simulation.}

\item{out_type}{Identifies the type of file generated, either an HTML file or a GIF file.}

\item{out_name}{Name used for the file(s) created by this function.}
}
\value{
For an HTML animation, the function saves four items in the working directory: a folder with CSS files, a folder with javascript files, a folder with the image files for the animation, and a .html file; the latter two files are named using the function's \code{out_name} argument. For a GIF animation, the function saves a single .gif file using the function's \code{out_name} argument. See the vignettes for examples.
}
\description{
Creates either an HTML or a GIF animation of a cyclic
voltammetry simulation created using \code{cvSim}. The
resulting animation displays the diffusion profiles for Ox,
Red, and, where appropriate, Z situated above the cyclic
voltammogram. Note: the \code{animateCV} function requires
that the \code{animation} package is installed.
}
