% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred_sources.R
\name{fred_sources}
\alias{fred_sources}
\alias{fred_source}
\alias{fred_source_releases}
\title{Fetch Information on a Data Source in FRED}
\usage{
fred_sources(key = NULL, args = list())

fred_source(..., key = NULL, args = list())

fred_source_releases(..., key = NULL, args = list())
}
\arguments{
\item{key}{32 character lower-cased alpha-numeric character string}

\item{args}{named list of other arguments passed to the API, mostly for \code{fred_source_releases}, including "limit", "offset", "sort_order", etc. See \code{\link{fred_search}} for more details on accepted parameters.}

\item{...}{character or numeric vectors of release ids to search}
}
\value{
data.frame with entries described in details
}
\description{
Each of the functions accept a source number and return the requested information in a data.frame.
}
\details{
Each function returns the following information in a data.frame.

\describe{
 \item{\code{fred_sources}}{Source id, its name, a url link, and realtime start and end dates}
 \item{\code{fred_source}}{Same as \code{fred_sources}}
 \item{\code{fred_source_releases}}{Release id, its name, a url link, whether there is a press release, and realtime start and end dates}
}
}
\section{Functions}{
\itemize{
\item \code{fred_sources}: get all sources of economic data

\item \code{fred_source}: get information about a particular source

\item \code{fred_source_releases}: get releases by a particular source
}}

