% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred_tags.R
\name{fred_tags}
\alias{fred_tags}
\alias{fred_related_tags}
\alias{fred_tags_series}
\title{Fetch Information on a Tag in FRED}
\usage{
fred_tags(key = NULL, args = list())

fred_related_tags(..., key = NULL, args = list())

fred_tags_series(..., key = NULL, args = list())
}
\arguments{
\item{key}{32 character lower-cased alpha-numeric character string}

\item{args}{named list of other arguments passed to the API, including "limit", "offset", "sort_order", etc. See \code{\link{fred_search}} for more details on accepted parameters.}

\item{...}{character vectors of tag names to search}
}
\value{
data.frame with entries described in details
}
\description{
Each of the functions accept a tag name and return the requested information in a data.frame.
}
\details{
Each function returns the following information in a data.frame.

\describe{
 \item{\code{fred_tags}}{Tag name, its group id, popularity, the number of series that are tagged, when it was created, and any notes about the tag}
 \item{\code{fred_related_tags}}{Same as \code{fred_tags}}
 \item{\code{fred_tags_series}}{Series id, its title, observations start and end, frequency, units, seasonal adjustment type, popularity, realtime start and end, and when it was last updated}
}
}
\section{Functions}{
\itemize{
\item \code{fred_tags}: get the tag names associated with the search parameters

\item \code{fred_related_tags}: get the tags that are related to one or more tag names

\item \code{fred_tags_series}: get the series associated with tags
}}

