% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehension.R
\name{comprehendSummary}
\alias{comprehendSummary}
\alias{All}
\alias{Any}
\alias{None}
\alias{Sum}
\alias{Prod}
\alias{Min}
\alias{Max}
\alias{Mean}
\alias{Stats}
\alias{Paste}
\title{Vectorized Comprehension and Summary}
\usage{
All(..., clust = NULL, na.rm = FALSE)

Any(..., clust = NULL, na.rm = FALSE)

None(..., clust = NULL, na.rm = FALSE)

Sum(..., clust = NULL, na.rm = FALSE)

Prod(..., clust = NULL, na.rm = FALSE)

Min(..., clust = NULL, na.rm = FALSE)

Max(..., clust = NULL, na.rm = FALSE)

Mean(..., clust = NULL, na.rm = FALSE, trim = 0)

Stats(..., clust = NULL, na.rm = FALSE, trim = 0)

Paste(..., clust = NULL, collapse = "")
}
\arguments{
\item{...}{vectors of any type or a \code{for} loop with format: \code{for (var in seq) <name => <if (cond)> expr}. See \code{\link{comprehension}}.}

\item{clust}{cluster to use for \code{\link[parallel:clusterApply]{parallel}} computations}

\item{na.rm}{logical; should missing values be removed? Defaults to \code{FALSE}}

\item{trim}{fraction between 0 and 0.5 describing percent of observations to be trimmed from each side for the mean}

\item{collapse}{character describing how the results from \code{Paste} should be collapsed. See \code{\link[base:paste]{paste}}.}
}
\value{
Single numeric or character value, or a list of results for \code{Stats}
}
\description{
Functions that summarize the results of a Python-style comprehension. These functions
extend those in \code{\link{comprehension}} by applying a post-evaluation function to
the results of the loop.
}
\section{Functions}{
\itemize{
\item \code{All}: Are all results \code{TRUE}?

\item \code{Any}: Are any results \code{TRUE}?

\item \code{None}: Are all results \code{FALSE}?

\item \code{Sum}: Calculate the \code{\link[base]{sum}} of results

\item \code{Prod}: Calculate the \code{\link[base]{prod}} of results

\item \code{Min}: Find the minimum in the result

\item \code{Max}: Find the maximum in the result

\item \code{Mean}: Calculate the arithmetic mean of the result

\item \code{Stats}: Find the 7 number summary (5 number + mean & sd) of the result

\item \code{Paste}: Collapse the result into a single character
}}

\examples{
## Calculate the sum of all even numbers to 100
Sum(for (i in seq(2, 100, 2)) i)

## Find the mean
Mean(for (i in 1:10) log(i))

## Combine character values
greet <- c("Hello", "World", "Nice", "To", "Meet", "You")
val <- Paste(for (i.j in enum(greet)) paste0(i, ": ", j), collapse="\n")
cat(val)

}
