% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper3D.R
\name{track.split.3d}
\alias{track.split.3d}
\title{This function splits the by outliers in the time lag.}
\usage{
track.split.3d(track, timeLag, lag = NULL, tolerance = NULL)
}
\arguments{
\item{track}{track data.frame with x, y and z coordinates}

\item{timeLag}{a numeric vector with the time passed between the fix point acquisition}

\item{lag}{NULL or a manually chosen lag}

\item{tolerance}{NULL or a manually chosen tolerance}
}
\value{
A list containing the splitted tracks.
}
\description{
The length of timeLag must be the the track's length minus 1 and represents
the time passed between the fix point acquisition
}
\examples{
track.split.3d(
  niclas,
  timeLag = rep(1, nrow(niclas) - 1) + rnorm(nrow(niclas) - 1,
  mean = 0,
  sd = 0.25)
)
}
