% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ecolRxC}
\alias{plot.ecolRxC}
\title{Graphical representation of a RxC ecological inference (vote transfer) matrix}
\usage{
\method{plot}{ecolRxC}(
  x,
  margins = TRUE,
  digits = 2,
  row.names = NULL,
  col.names = NULL,
  size.numbers = 6,
  size.labels = 4,
  size.margins = 4,
  colour.cells = "cyan4",
  colour.grid = "cornsilk2",
  alpha = 0.5,
  which = NULL,
  ...,
  show.plot = TRUE
)
}
\arguments{
\item{x}{An object output of the \strong{ecolRxC} function.}

\item{margins}{A TRUE/FALSE argument informing if the margins of the matrix should be displayed. Default TRUE.}

\item{digits}{Integer indicating the number of decimal places to be shown. Default, 2.}

\item{row.names}{Names to be used for the rows of the matrix.}

\item{col.names}{Names to be used for the columns of the matrix.}

\item{size.numbers}{A reference number indicating the average font size to be used for the transfer numbers. Default, 6.}

\item{size.labels}{A number indicating the font size to be used for labels. Default, 4.}

\item{size.margins}{A number indicating the font size to be used for margin numbers. Default, 4.}

\item{colour.cells}{Background base colour for cells.}

\item{colour.grid}{Colour to be used for grid lines.}

\item{alpha}{A [0,1] number of colour transparency.}

\item{which}{A vector of integers informing the units for which the aggregate transfer matrix should be plotted. Default, NULL, the global matrix is shown.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{show.plot}{A TRUE/FALSE indicating if the plot should be displayed as a side-effect. By default, TRUE.}
}
\value{
Invisibly returns the (ggplot) description of the plot, which is a list with components that contain the plot itself, the data, information about the scales, panels etc.
}
\description{
Plot method for objects obtained with ecolRxC.
}
\note{
ggplot2 is needed to be installed for this function to work.
}
\examples{
votes1 <- structure(list(P1 = c(16L, 4L, 13L, 6L, 1L, 16L, 6L, 17L, 48L, 14L),
                         P2 = c(8L, 3L, 0L, 5L, 1L, 4L, 7L, 6L, 28L, 8L),
                         P3 = c(38L, 11L, 11L, 3L, 13L, 39L, 14L, 34L, 280L, 84L),
                         P4 = c(66L, 5L, 18L, 39L, 30L, 57L, 35L, 65L, 180L, 78L),
                         P5 = c(14L, 0L, 5L, 2L, 4L, 21L, 6L, 11L, 54L, 9L),
                         P6 = c(8L, 2L, 5L, 3L, 0L, 7L, 7L, 11L, 45L, 17L),
                         P7 = c(7L, 3L, 5L, 2L, 3L, 17L, 7L, 13L, 40L, 8L)),
                         row.names = c(NA, 10L), class = "data.frame")
votes2 <- structure(list(C1 = c(2L, 1L, 2L, 2L, 0L, 4L, 0L, 4L, 19L, 14L),
                         C2 = c(7L, 3L, 1L, 7L, 2L, 5L, 3L, 10L, 21L, 6L),
                         C3 = c(78L, 7L, 28L, 42L, 28L, 84L, 49L, 85L, 260L, 100L),
                         C4 = c(56L, 14L, 20L, 7L, 19L, 54L, 22L, 50L, 330L, 91L),
                         C5 = c(14L, 3L, 6L, 2L, 3L, 14L, 8L, 8L, 45L, 7L)),
                         row.names = c(NA, 10L), class = "data.frame")
example <- ecolRxC(votes1, votes2, method = "IPF")
p <- plot(example, show.plot = FALSE)
p

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
