% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-q.R
\name{q_graph}
\alias{q_graph}
\alias{q_graph.auto_edina}
\alias{q_graph.edina}
\alias{q_graph.matrix}
\alias{q_graph.q_matrix}
\title{Graph Q Matrix}
\usage{
q_graph(x, ...)

\method{q_graph}{auto_edina}(x, binary = TRUE, ic = c("ppp", "bic", "dic"), ...)

\method{q_graph}{edina}(x, binary = TRUE, ...)

\method{q_graph}{matrix}(x, ...)

\method{q_graph}{q_matrix}(x, ...)
}
\arguments{
\item{x}{Either an \code{edina}, \code{auto_edina}, or \code{q_matrix} object.}

\item{...}{Additional parameters not used}

\item{binary}{Boolean to indicate if a classified Q (dichotomous by decision rule)
or an estimate Q (non-dichotomous) or should be shown.
Default: \code{TRUE}.}

\item{ic}{Information criterion name. Default \code{"ppp"}.}
}
\value{
A \code{ggplot2} object with a heatmap overview of the estimated Q matrix.
}
\description{
Provides a heatmap approach to showing the estimated binary or averaged
values of the Q Matrix.
}
\examples{
q = q_matrix(matrix(c(1, 0, 1, 1, 0, 1), ncol = 3))
q_graph(q)
}
