% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customizable_functions.R
\name{create_sims}
\alias{create_sims}
\title{Create simulated data for many repetitions}
\usage{
create_sims(n_reps, n, rr, central, average_outcome, sd = NULL, exposure_type,
  exposure_trend, exposure_slope = 1, exposure_amp = NULL,
  outcome_trend = NULL, outcome_slope = 1, outcome_amp = NULL,
  start.date = "2000-01-01", cust_exp_func = NULL, cust_exp_args = NULL,
  cust_expdraw = NULL, cust_expdraw_args = NULL, cust_base_func = NULL,
  cust_lambda_func = NULL, cust_base_args = NULL, cust_lambda_args = NULL,
  cust_outdraw = NULL, cust_outdraw_args = NULL)
}
\arguments{
\item{n_reps}{An integer specifying the number of datasets to simulate (e.g.,
\code{n_reps = 1000} would simulate one thousand time series datasets with the
specified characteristics, which can be used for a power analysis or to investigate
the performance of a proposed model).}

\item{n}{An integer specifying the number of days to simulate (e.g., \code{n = 365}
would simulate a dataset with a year's worth of data).}

\item{rr}{A non-negative numeric value specifying the relative risk (i.e., the
relative risk per unit increase in the exposure).}

\item{central}{A numeric value specifying the mean probability of exposure
(for binary data) or the mean exposure value (for continuous data).}

\item{average_outcome}{A non-negative numeric value specifying the average
daily outcome count.}

\item{sd}{A non-negative numeric value giving the standard deviation of the exposure
values from the exposure trend line (not the total standard deviation of
the exposure values).}

\item{exposure_type}{A character string specifying the type of exposure.
Choices are "binary" or "continuous".}

\item{exposure_trend}{A character string specifying a seasonal and / or long-term trend for
    expected mean exposure. See the vignette for \code{eesim} for examples of each option.
    The shapes are based on those used in Bateson and Schwartz (1999).
    For trends with a seasonal component, the amplitude of the seasonal trend can be
    customized using the \code{exposure\_amp} argument. For trends with a long-term
    pattern, the slope of the long-term trend can be set using the \code{exposure\_slope}
    argument.
    If using the "monthly" option for a binary exposure, you must input a numeric
    vector of length 12 for the \code{central} argument that gives the probability of
    exposure for each month, starting in January and ending in December.
    Options for continuous exposure are:
\itemize{
  \item{"no trend": No trend, either seasonal or long-term (default).}
  \item{"cos1": A seasonal trend only.}
  \item{"cos2": A seasonal trend with variable amplitude across years.}
  \item{"cos3": A seasonal trend with steadily decreasing amplitude over time.}
  \item{"linear": A linear long-term trend with no seasonal trend.}
  \item{"curvilinear": A curved long-term trend with no seasonal trend.}
  \item{"cos1linear": A seasonal trend plus a linear long-term trend.}
  }
   Options for binary exposure are:
   \itemize{
  \item{"no trend": No trend, either seasonal or long-term (default).}
  \item{"cos1": A seasonal trend only.}
  \item{"cos2": A seasonal trend with variable amplitude across years.}
  \item{"cos3": A seasonal trend with steadily decreasing amplitude over time.}
  \item{"linear": A linear long-term trend with no seasonal trend.}
  \item{"monthly": Uses a user-specified probability of exposure for each month.}
}}

\item{exposure_slope}{A numeric value specifying the linear slope of the
exposure, to be used with \code{exposure_trend = "linear"} or
\code{exposure_trend = "cos1linear"}.
The default value is 1. Positive values will generate data with an
increasing expected value over the years while negative values will
generate data with decreasing expected value over the years.}

\item{exposure_amp}{A numeric value specifying the amplitude of the exposure
trend. Must be between -1 and 1 for continuous exposure or between -0.5
and 0.5 for binary exposure. Positive values will simulate a pattern
with higher values at the time of the year of the start of the dataset
(typically January) and lowest values six months following that (typically
July). Negative values can be used to simulate a trend with lower values
at the time of year of the start of the dataset and higher values in the
opposite season.}

\item{outcome_trend}{A character string specifying the seasonal trend in
health outcomes.  Options are the same as for continuous exposure
data.}

\item{outcome_slope}{A numeric value specifying the linear slope of the
outcome trend, to be used with \code{outcome_trend = "linear"} or
\code{outcome_trend = "cos1linear"}. The default value is 1.
Positive values will generate data with an
increasing expected value over the years while negative values will
generate data with decreasing expected value over the years.}

\item{outcome_amp}{A numeric value specifying the amplitude of the outcome
trend.  Must be between -1 and 1.}

\item{start.date}{A date of the format "yyyy-mm-dd" from which to begin
simulating daily exposures}

\item{cust_exp_func}{An R object name specifying the name of a custom
trend function to generate exposure data}

\item{cust_exp_args}{A list of arguments and their values for the
user-specified custom exposure function.}

\item{cust_expdraw}{An R object specifying a user-created function
which determines the distribution of random noise off of the trend line.
This function must have inputs \code{n} and \code{prob} for a binary exposure
function and inputs \code{n} and \code{mean} for a continuous exposure function.
The custom function must output a vector of simulated exposure values.}

\item{cust_expdraw_args}{A list of arguments other than \code{n} required by the
\code{cust_expdraw} function.}

\item{cust_base_func}{A R object name specifying a user-made custom
function for baseline trend.}

\item{cust_lambda_func}{An R object name specifying a user-made custom
function for relating baseline, relative risk, and exposure}

\item{cust_base_args}{A list of arguments and their values used in the
user-specified custom baseline function}

\item{cust_lambda_args}{A list of arguments and their values used in the
user-specified custom lambda function}

\item{cust_outdraw}{An R object name specifying a user-created function to
randomize the outcome values off of the baseline for outcome values. This
function must take inputs \code{n} and \code{lambda} and output a vector of outcome
values.}

\item{cust_outdraw_args}{A list of arguments besides \code{n} passed
to the user-created custom outcome draw function.}
}
\value{
A list object of length \code{n_rep}, in which each list element is one of the
   synthetic datasets simulated under the input conditions. Each synthetic dataset includes
   columns for for date (\code{date}), daily exposure (\code{x}), and daily outcome count
   (\code{outcome}).
}
\description{
Creates a collection of synthetic datasets that follow a set of user-specified
conditions (e.g., exposure mean and variance, average daily outcome count,
long-term and seasonal trends in exposure and outcome, association between exposure
and outcome). These synthetic datasets can be used to investigate performance of a specific
model or to estimate power or required sample size for a hypothetical study.
}
\examples{
create_sims(n_reps=3, n=100, central = 100, sd = 10,
            exposure_type="continuous", exposure_trend = "cos1",
            exposure_amp = .6, average_outcome = 22,
            outcome_trend = "no trend", outcome_amp = .6, rr = 1.01)

}
\references{
Bateson TF, Schwartz J. 1999. Control for seasonal variation and time trend in
    case-crossover studies of acute effects of environmental exposures. Epidemiology
    10(4):539-544.
}
