% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler-backends.R
\name{register_backend}
\alias{register_backend}
\title{Register a new backend for a tensor type}
\usage{
register_backend(
  tensor_type,
  backend_class,
  dependencies = character(0),
  testing = FALSE,
  aliases = character(0)
)
}
\arguments{
\item{tensor_type}{A string specifying the tensor type the backend supports.}

\item{backend_class}{An R6Class generator for the backend (subclass of
\link{EinopsBackend}). Note that this binding does not necessarily have to have a
defined value at the time of calling this function.}

\item{dependencies}{Optional character vector of required package names.}

\item{testing}{If TRUE, indicates its only used for testing.}

\item{aliases}{Optional character vector of aliases for the tensor type.}
}
\value{
Invisibly returns the backend registry object.
}
\description{
Registers a backend implementation for a specific tensor type, along with any
required dependencies, testing flag, and optional aliases. This function
wraps the backend class in a \code{\link[=thunk]{thunk()}} and registers it with the backend
registry.
}
\keyword{internal}
