% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GENESISClasses.R
\docType{class}
\name{RE1-class}
\alias{RE1-class}
\alias{header,RE1-method}
\alias{footer,RE1-method}
\alias{re1,RE1-method}
\alias{re1total,RE1-method}
\alias{content,RE1-method}
\alias{region,RE1-method}
\alias{protocol,RE1-method}
\alias{RegExp1}
\alias{length,RE1-method}
\alias{show,RE1-method}
\alias{selectYears,RE1-method}
\alias{selectRegion,RE1-method}
\alias{readRegExp}
\title{RE1 class for 'GENESIS-Tabelle: 12411-03-03-4'}
\usage{
\S4method{header}{RE1}(object)

\S4method{footer}{RE1}(object)

\S4method{re1}{RE1}(object)

\S4method{re1total}{RE1}(object)

\S4method{content}{RE1}(object)

\S4method{region}{RE1}(object)

\S4method{protocol}{RE1}(object)

RegExp1(header, footer, re1, re1total, content, region, protocol)

\S4method{length}{RE1}(x)

\S4method{show}{RE1}(object)

\S4method{selectYears}{RE1}(object, selectYears)

\S4method{selectRegion}{RE1}(object, selectRegion)

readRegExp(infile)
}
\arguments{
\item{object}{RE1-object}

\item{header}{vector}

\item{footer}{vector}

\item{re1}{data.table}

\item{re1total}{data.table}

\item{content}{character}

\item{region}{character}

\item{protocol}{character}

\item{x}{RE1-object}

\item{selectYears}{vector}

\item{selectRegion}{vector}

\item{infile}{character file name}
}
\value{
The \code{header}-method returns the raw header information

The \code{footer}-method returns the raw footer information

The \code{re1}-method returns the exposure table

The \code{re1total}-method returns the exposure total sums table

The \code{content}-method returns the content information

The \code{region}-method returns the regional information

The \code{protocol}-method returns the protocol information

The \code{RegExp1}-constructor returns an RE1 object

The \code{length}-method returns the number of rows

The \code{selectYears}-method returns an RE1 object

The \code{selectRegion}-method returns an RE1 object

The \code{readRegExp}-method returns an RE1 object
}
\description{
The class \code{RE1} stores GENESIS table information in a systematic way.

The \code{header}-method gets the raw header information of an RE1 object

The \code{footer}-method gets the raw footer information of an RE1 object

The \code{re1}-method gets the exposure table information of an RE1 object

The \code{re1total}-method gets the exposure total sums table information of an RE1 object

The \code{content}-method gets the exposure table information of an RE1 object

The \code{region}-method gets the regional information of an RE1 object

The \code{protocol}-method gets the protocol information of an RE1 object

The \code{RegExp1}-constructor creates an RE1 object

The \code{length}-method gets the number of rows int the RE1 re1 data.table

The \code{selectYears}-method gets a subset of an RE1 object

The \code{selectRegion}-method gets a subset of an RE1 object

The \code{readRegExp}-method reads all information from 'GENESIS-Tabelle: 12411-03-03-4'
}
\details{
This \code{RE1} class fits to the GENESIS table 12411-03-03-4.
See https://www.regionalstatistik.de/genesis/online for data details.
An RE1 instance stores the raw header, the raw footer, the content,
the version protocol and regional information and the
exposure information as a data.table object. Further it stores a second data.table
with the total sums information.
Try demo(RE1) for a demonstration.
}
\section{Slots}{

\describe{
\item{\code{content}}{describes the content}

\item{\code{region}}{regional entity}

\item{\code{header}}{includes the raw header information}

\item{\code{footer}}{includes the raw footer information}

\item{\code{re1}}{stores the exposure table (data.table)}

\item{\code{re1total}}{stores the exposure total sums table (data.table)}

\item{\code{protocol}}{contains the protocol information}
}}

\examples{
r1 <- readRegExp(file.path(system.file(package="eoR"), "extdata", "12411-03-03-4m.csv"))
header(r1)
footer(r1)
re1(r1)[, table(Year)]
}
