% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_casos_payback.R
\encoding{UTF-8}
\name{epe4md_casos_payback}
\alias{epe4md_casos_payback}
\title{Cria a base de casos para serem simulados posteriormente no cálculo do
payback.}
\usage{
epe4md_casos_payback(
  ano_base,
  ano_max_resultado = 2050,
  inflacao = 0.0375,
  ano_troca_inversor = 11,
  fator_custo_inversor = 0.15,
  dir_dados_premissas = NA_character_
)
}
\arguments{
\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{ano_max_resultado}{numeric. Ano final para apresentação dos resultados.
Máximo igual a 2050. Default igual a 2050.}

\item{inflacao}{numeric. Taxa de inflacão considerada no reajuste das tarifas
e para calcular o retorno real de projetos.}

\item{ano_troca_inversor}{numeric. Ano, a partir do ano de instalação, em que
é realizada a troca do inversor fotovoltaico. Default igual a 11.}

\item{fator_custo_inversor}{numeric. Custo do inversor para a substituição em
percentual do CAPEX total do sistema de geração. Default igual a 0.15.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas. Se esse
parâmetro não for passado, a função usa os dados default que são instalados
com o pacote. É importante que os nomes dos arquivos sejam os mesmos da
pasta default.}
}
\value{
data.frame. Casos para serem simulados posteriormente no cálculo do
payback.
}
\description{
Cria a base de casos para serem simulados posteriormente no cálculo do
payback.
}
\examples{

casos_payback <-
  epe4md_casos_payback(
    ano_base = 2021,
    ano_max_resultado = 2050,
    inflacao = 0.0375,
    ano_troca_inversor = 11,
    fator_custo_inversor = 0.15,
    dir_dados_premissas = NA_character_
)
}
