% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_graficos.R
\encoding{UTF-8}
\name{epe4md_graf_part_segmento}
\alias{epe4md_graf_part_segmento}
\title{Gráfico da evolução da participação por segmento}
\usage{
epe4md_graf_part_segmento(dados, ano_inicio = 2013, tamanho = 14)
}
\arguments{
\item{dados}{data.frame. Resultados mensais de potência e energia.}

\item{ano_inicio}{numeric. Define o ano em que se inicia o eixo x. Default igual a 2013.}

\item{tamanho}{numeric. Altera o tamanho da fonte da legenda. Default igual a 14.}
}
\description{
Gráfico de colunas que mostra a participação de cada segmento 'Comercial (AT)', 'Comercial(BT)', 'Comercial Remoto (AT/BT)', Residencial' e 'Residencial Remoto' na geração de energia em cada ano.
}
\value{
Plota um gráfico de colunas que mostra a participação de cada segmento 'Comercial (AT)', 'Comercial(BT)', 'Comercial Remoto (AT/BT)', Residencial' e 'Residencial Remoto' na geração de energia em cada ano.
}
\examples{

dados <- structure(
  list(
    data = structure(c(18932, 17956, 18201), class = "Date"),
    ano = c(2021, 2019, 2019),
    mes = c(11, 3, 11),
    nome_4md = c("RORAIMA", "RORAIMA", "RORAIMA"),
    subsistema = c("MAN", "MAN", "MAN"),
    uf = c("RR", "RR", "RR"),
    segmento = c("comercial_at", "comercial_at", "comercial_at"),
    fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica"),
    energia_mwh = c(627.959044043851, 42.0777734281515, 42.5086240693568),
    energia_autoc_mwh = c(502.36723523508, 33.6622187425212, 34.0068992554854),
    energia_inj_mwh = c(125.59180880877, 8.41555468563031, 8.50172481387135),
    energia_mwmed = c(Nov = 0.872165338949792, Mar = 0.0565561470808488,
                      Nov = 0.0590397556518844),
    pot_mes_mw = c(0.01199, 0, 0),
    adotantes_mes = c(1, 0, 0),
    p = c(0.000122298434419402, 0.000122298434419402, 0.000122298434419402),
    q = c(1, 1, 1),
    regiao = c("N", "N", "N")),
  row.names = c(NA, -3L),
  class = c("tbl_df", "tbl", "data.frame")
  )

graf_part_segmento <- epe4md_graf_part_segmento(
  dados = dados,
  ano_inicio = 2021,
  tamanho = 14
)
}
