% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_total_urbano.R
\name{get_total_urbano}
\alias{get_total_urbano}
\title{Descarga de Bases de EPH total urbano}
\usage{
get_total_urbano(
  year = 2016,
  type = "individual",
  vars = "all",
  destfile = NULL
)
}
\arguments{
\item{year}{un integer o vector de integers a partir de 2016}

\item{type}{tipo de base a descargar: 'individual' ; 'hogar'}

\item{vars}{opcional: un vector de characters. variables a seleccionar. Default = 'all' trae todas las variables}

\item{destfile}{opcional: un string con la direccion de un archivo .RDS. Si se ingresa un path a un archivo que no existe, se descarga
el archivo y se graba en esa direccion. Si existe un archivo en ese path, se lee el archivo.}
}
\value{
Devuelve la o las bases de la EPH total urbano solicitadas
}
\description{
Funcion que descarga bases de la Encuesta Permanente de Hogares total urbano del INDEC a partir de 2016
}
\details{
disclaimer: El script no es un producto oficial de INDEC.
}
\examples{
base_individual <- get_total_urbano(
  year = 2016,
  type = "hogar",
  vars = c("PONDERA", "IV1", "IV2")
)

}
