% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_epicontacts.R
\name{vis_epicontacts}
\alias{vis_epicontacts}
\title{Plot epicontacts objects using visNetwork}
\usage{
vis_epicontacts(
  x,
  thin = TRUE,
  node_color = "id",
  label = "id",
  annot = TRUE,
  node_shape = NULL,
  shapes = NULL,
  edge_label = NULL,
  edge_color = NULL,
  legend = TRUE,
  legend_max = 10,
  x_axis = NULL,
  col_pal = cases_pal,
  NA_col = "lightgrey",
  edge_col_pal = edges_pal,
  width = "90\%",
  height = "700px",
  selector = TRUE,
  editor = FALSE,
  edge_width = 3,
  ...
)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object.}

\item{thin}{A logical indicating if the data should be thinned with \code{\link{thin}} so that only cases with contacts should be plotted.}

\item{node_color}{An index or character string indicating which field of the
linelist should be used to color the nodes.}

\item{label}{An index, logical, or character string indicating which fields
of the linelist should be used for labelling the nodes. Logical will be
recycled if necessary, so that the default \code{TRUE} effectively uses all
columns of the linelist.}

\item{annot}{An index, logical, or character string indicating which fields
of the linelist should be used for annotating the nodes. Logical will be
recycled if necessary, so that the default \code{TRUE} effectively uses all
columns of the linelist.}

\item{node_shape}{An index or character string indicating which field of the
linelist should be used to determine the shapes of the nodes.}

\item{shapes}{A named vector of characters indicating which icon code should
be used for each value \code{node_shape}, e.g. \code{c(m = "male", f =
"female")} if 'm' amd 'f' are values from \code{node_shape}. See
\code{\link{codeawesome}} for all available codes.}

\item{edge_label}{An index or character string indicating which field of the
contacts data should be used to label the edges of the graph.}

\item{edge_color}{An index or character string indicating which field of the
contacts data should be used to color the edges of the graph.}

\item{legend}{A logical indicating whether a legend should be added to the
plot.}

\item{legend_max}{The maximum number of groups for a legend to be displayed.}

\item{x_axis}{Feature currently only available in development "timeline" branch.}

\item{col_pal}{A color palette for the nodes.}

\item{NA_col}{The color used for unknown group.}

\item{edge_col_pal}{A color palette for the edges.}

\item{width}{The width of the output, in html compatible format (e.g. '90\%'
or '800px').}

\item{height}{The height of the output, in html compatible format
(e.g. '800px').}

\item{selector}{A logical indicating if the selector tool should be used;
defaults to TRUE.}

\item{editor}{A logical indicating if the editor tool should be used;
defaults to FALSE.}

\item{edge_width}{An integer indicating the width of the edges. Defaults to
3.}

\item{...}{Further arguments to be passed to \code{visNetwork}.}
}
\value{
The same output as \code{visNetwork}.
}
\description{
This function plots \code{\link{epicontacts}} objects using the
\code{visNetwork} package. The produced object is an \code{htmlwidget} which
will need rendering within a web browser.
}
\examples{
if (require(outbreaks)) {

## example using MERS outbreak in Korea, 2014
head(mers_korea_2015[[1]])
head(mers_korea_2015[[2]])

x <- make_epicontacts(linelist=mers_korea_2015[[1]],
                       contacts = mers_korea_2015[[2]],
                       directed=TRUE)

\dontrun{
plot(x)
plot(x, node_color = "place_infect")
# show transmission tree with time as the horizontal axis, showing all nodes
#' plot(x, node_color = "loc_hosp", legend_max=20, annot=TRUE)
#' plot(x, "place_infect", node_shape = "sex",
     shapes = c(M = "male", F = "female"))

plot(x, "sex", node_shape = "sex", shapes = c(F = "female", M = "male"),
     edge_label = "exposure", edge_color = "exposure")
}
}
}
\seealso{
\code{\link[visNetwork]{visNetwork}} in the package \code{visNetwork}.
  \code{\link{edges_pal}} and \code{\link{cases_pal}} for color palettes used
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
VP Nagraj (\email{vpnagraj@virginia.edu})
Zhian N. Kamvar (\email{zkamvar@gmail.com})
}
