% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-law.R
\name{a2a}
\alias{a2a}
\alias{a2a.numeric}
\alias{a2a.list}
\title{Easily switch between different power law formulations.}
\usage{
a2a(x, ...)

\method{a2a}{numeric}(
  x,
  slope,
  n,
  from = c("Ai", "ai", "AI", "aI"),
  to = c("Ai", "ai", "AI", "aI"),
  ...
)

\method{a2a}{list}(x, to = c("Ai", "ai", "AI", "aI"), ...)
}
\arguments{
\item{x}{Intercept parameter to be converted or a named list with the
parameter to be converted ("Ai", "ai", "AI" or "aI"), the slope
("slope"), and the number of individual per sampling unit ("n").}

\item{...}{Additional arguments to be passed to other methods.}

\item{slope}{Slope parameter.}

\item{n}{Number of individuals per sampling unit.}

\item{from}{Kind of the input intercept parameter ("Ai", "ai", "AI" or "aI").}

\item{to}{Desired kind for the ouput intercept parameter ("Ai", "ai", "AI" or
"aI").}
}
\value{
A numeric vector.
}
\description{
\code{a2a} was designed to avoid headaches that are likely to occur when
working with different formulations of the binomial power law analysis.
}
\details{
The binomial power law can be expressed as: \eqn{s_y^2 = (intercept)(s_{bin}^2)^b}.
But different forms of (intercept) are possible depending on the formulation of the
binomial power law.
\tabular{ccccc}{
      \tab Ai         \tab ai      \tab AI         \tab aI      \cr
   Ai \tab 1          \tab n^b     \tab n^(2(b-1)) \tab n^(b-2) \cr
   ai \tab n^(-b)     \tab 1       \tab n^(b-2)    \tab n^(-2)  \cr
   AI \tab n^(2(1-b)) \tab n^(2-b) \tab 1          \tab n^(-b)  \cr
   aI \tab n^(2-b)    \tab n^2     \tab n^b        \tab 1       \cr
}
}
\examples{
# Values from the power_law() example:
Ai    <- 38.6245
slope <- 1.9356
n     <- 9

# Usual function call syntax:
a2a(Ai, slope, n, from = "Ai", to = "ai")

# Other syntaxes:
inputs <- list(Ai = Ai, slope = slope, n = n)
a2a(inputs, "ai")
require(magrittr)
inputs \%>\% a2a("ai")

}
