% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{ui_epoxy_html}
\alias{ui_epoxy_html}
\alias{epoxyHTML}
\title{Epoxy HTML Output for Shiny}
\usage{
ui_epoxy_html(
  .id,
  ...,
  .class = NULL,
  .style = NULL,
  .item_tag = "span",
  .item_class = NULL,
  .placeholder = "",
  .sep = "",
  .open = "{{",
  .close = "}}",
  .na = "",
  .null = "",
  .literal = FALSE,
  .trim = FALSE,
  .aria_live = c("polite", "off", "assertive"),
  .aria_atomic = TRUE,
  .class_item = deprecated(),
  .container = deprecated(),
  .container_item = deprecated()
)

epoxyHTML(.id, ...)
}
\arguments{
\item{.id}{The output id}

\item{...}{UI elements or text (that will be treated as HTML), containing
template variables. Use named values to provide initial placeholder values.}

\item{.class, .style}{Classes and inline style directives added to the
\verb{<epoxy-html>} container into which the elements in \code{...} are placed.}

\item{.item_tag, .item_class}{The HTML element tag name and classes used to
wrap each template variable. By default, each template is wrapped in a
\verb{<span>}.}

\item{.placeholder}{Default placeholder if a template variable placeholder
isn't provided.}

\item{.sep}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}

\item{.open}{[\code{character(1)}: \sQuote{\\\{}]\cr The opening delimiter around
the template variable or expression. Doubling the full delimiter escapes
it.}

\item{.close}{[\code{character(1)}: \sQuote{\\\}}]\cr The closing delimiter
around the template variable or expression. Doubling the full delimiter
escapes it.}

\item{.na}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace \code{NA} values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}

\item{.null}{[\code{character(1)}: \sQuote{character()}]\cr Value to replace
NULL values with. If \code{character()} whole output is \code{character()}. If
\code{NULL} all NULL values are dropped (as in \code{paste0()}). Otherwise the
value is replaced by the value of \code{.null}.}

\item{.literal}{[\code{boolean(1)}: \sQuote{FALSE}]\cr Whether to treat single or
double quotes, backticks, and comments as regular characters (vs. as
syntactic elements), when parsing the expression string. Setting \code{.literal = TRUE} probably only makes sense in combination with a custom
\code{.transformer}, as is the case with \code{glue_col()}. Regard this argument
(especially, its name) as experimental.}

\item{.trim}{[\code{logical(1)}: \sQuote{TRUE}]\cr Whether to trim the input
template with \code{\link[glue:trim]{trim()}} or not.}

\item{.aria_live, .aria_atomic}{The
\href{https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-live}{aria-live}
and \href{https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-atomic}{aria-atomic}
attribute values for the entire template region. By default, with
\code{"polite"}, any updates within the region will be announced via screen
readers.

If your template includes changes in lots of disparate areas, it would be
better to set \code{"aria-live" = "polite"} and \code{"aria-atomic" = "true"} on
specific regions that should be announced together. Otherwise, the default
is to announce the entire region within the \code{ui_epoxy_html()} whenever any
of the values within change. In other words, set \code{.aria_live = "off"} and
\code{.aria_atomic = NULL} on the \code{ui_epoxy_html()} parent item and then set
\code{"aria-live" = "polite"} and \code{"aria-atomic" = "true"} on the parent
containers of each region in the app that receives updates.
\code{ui_epoxy_html()} does targeted updates, changing only the parts of the
UI that have changed.}

\item{.class_item}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in
\pkg{epoxy} v1.0.0, please use \code{.item_class} instead.}

\item{.container}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in
\pkg{epoxy} v1.0.0, where the container is now always \verb{<epoxy-html>}.}

\item{.container_item}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in
\pkg{epoxy} v1.0.0, please use \code{.item_tag} instead.}
}
\value{
An HTML object.
}
\description{
A glue-like output for Shiny. \code{ui_epoxy_html()} lets you use placeholders in
your HTML such as \code{"{{first_name}}"}, that are provided values from the
server by giving \code{render_epoxy()} a \code{first_name} value. Unlike
\code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}, updates are highly targeted: only the regions where
the server-side data have changed are updated in \code{ui_epoxy_html()}.
}
\section{Functions}{
\itemize{
\item \code{epoxyHTML()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated
alias, please use \code{ui_epoxy_html()}.

}}
\section{HTML Markup}{
 By default, placeholders are inserted into a \verb{<span>}
element in your UI, with the classes specified in \code{.class_item}.

\code{ui_epoxy_html()} also supports an HTML markup syntax similar to
\href{https://pughtml.com/what-is-pug-html}{pug} (an HTML preprocessor). As an
example, the markup syntax

\if{html}{\out{<div class="sourceCode">}}\preformatted{"\{\{h3.example.basic#basic-three demo\}\}"
}\if{html}{\out{</div>}}

creates a \code{demo} placeholder inside the following tag.

\if{html}{\out{<div class="sourceCode">}}\preformatted{<h3 id="basic-three" class="example basic"></h3>
}\if{html}{\out{</div>}}

The placeholder template string follows the pattern \verb{\{\{<markup> <name>\}\}}.
The markup syntax comes first, separated from the placeholder name by a
space. The HTML element is first, followed by classes prefixed with \code{.} or
and ID prefixed with \verb{#}. The template markup can contain only one element
and one ID, but many classes can be specified.

By default, the placeholder is assumed to be text content and any HTML
in the sent to the placeholder will be escaped --- in other words if you sent
\code{"<strong>word</strong>"}, you'd see that exact literal text in your app,
rather than an emboldened \strong{word}. To mark a placeholder as safe to accept
HTML, use \verb{!!} before the placeholder, e.g. \verb{\{\{<markup> !!<name>\}\}}. So
\verb{\{\{h3 !!demo\}\}} will create an \verb{<h3>} tag that accepts HTML within it.
}

\examples{
\dontshow{if (rlang::is_installed("shiny")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)

ui <- fluidPage(
  h2("ui_epoxy_html demo"),
  ui_epoxy_html(
    .id = "example",
    .item_class = "inner",
    fluidRow(
      tags$div(
        class = "col-xs-4",
        selectInput(
          inputId = "thing",
          label = "What is this {{color}} thing?",
          choices = c("apple", "banana", "coconut", "dolphin")
        )
      ),
      tags$div(
        class = "col-xs-4",
        selectInput(
          inputId = "color",
          label = "What color is the {{thing}}?",
          c("red", "blue", "black", "green", "yellow")
        )
      ),
      tags$div(
        class = "col-xs-4",
        sliderInput(
          inputId = "height",
          label = "How tall is the {{color}} {{thing}}?",
          value = 5,
          min = 0,
          max = 10,
          step = 0.1,
          post = "ft"
        )
      )
    ),
    tags$p(class = "big", "The {{color}} {{thing}} is {{height}} feet tall."),
    # Default values for placeholders above.
    thing = "THING",
    color = "COLOR",
    height = "HEIGHT"
  ),
  tags$style(HTML(
    ".big { font-size: 1.5em; }
     .inner { background-color: rgba(254, 233, 105, 0.5);}
     .epoxy-item__placeholder { color: #999999; background-color: unset; }"
  ))
)

server <- function(input, output, session) {
  output$example <- render_epoxy(
    thing = input$thing,
    color = input$color,
    height = input$height
  )
}

if (interactive()) {
  shinyApp(ui, server)
}
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
run_epoxy_example_app("ui_epoxy_html")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}, \code{\link[=render_epoxy]{render_epoxy()}}
}
