% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.add_utility}
\alias{.add_utility}
\title{Add utility values to a data frame}
\usage{
.add_utility(df, eq5d_version, country)
}
\arguments{
\item{df}{A data frame containing the state data. The state must be included in the data frame as a character vector under the column named `state`.}

\item{eq5d_version}{A character string specifying the version of EQ-5D, i.e. 3L or 5L.}

\item{country}{A character string representing the name of the country. This could be in a 2-letter format, full name or short name, as specified in the country_codes datasets.}
}
\value{
A data frame with an additional column named `utility` containing the calculated utility values. If the input country name is not found in the country_codes dataset, a list of available codes is printed, and subsequentyl an error message is displayed and the function stops.
}
\description{
This function adds utility values to a data frame based on a specified version of EQ-5D and a country name.
}
\examples{
df <- data.frame(state = c("11111", "11123", "32541"))
.add_utility(df, "5L", "DK")
}
