% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yr_sort_range.R
\name{yr_sort}
\alias{yr_sort}
\title{Chronological ordering of year vectors}
\usage{
yr_sort(x, reverse = FALSE, ...)
}
\arguments{
\item{x}{\link{yr} vector with era}

\item{reverse}{Set \code{FALSE} (the default) for chronological order (earliest to
latest) or \code{TRUE} for reverse chronological order (latest to earliest).}

\item{...}{Other arguments passed to \code{\link[=sort]{sort()}}; in particular use \code{na.last} to
control NA handling.}
}
\value{
Sorted \link{yr} vector
}
\description{
Sorts a vector of years into earliest-to-latest or latest-to-earliest
chronological order based on its era.
}
\details{
This is implemented as a prefixed function rather than an S3 \code{\link[=sort]{sort()}} method
for \link{yr}s to avoid surprises when numerical (i.e. not chronological) sorting
is expected.
}
\examples{
# Forward-counting era:
x <- yr(c(200, 100, 300), "CE")
yr_sort(x)
yr_sort(x, reverse = TRUE)

# Backward-counting era:
y <- yr(c(200, 100, 300), "BCE")
yr_sort(y)
yr_sort(y, reverse = TRUE)
}
\seealso{
Other functions for chronological ordering and extremes: 
\code{\link{yr_extremes}}
}
\concept{functions for chronological ordering and extremes}
