% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt.R
\name{txt}
\alias{txt}
\title{Custom Text for Rmarkdown with Counting}
\usage{
txt(
  id = "text_issue",
  title = "Issue",
  text = "",
  count = TRUE,
  output_file = NULL
)
}
\arguments{
\item{id}{A character string specifying the unique identifier for the HTML span element. Default identifiers are "text_issue", "text_inspect", "text_mod".}

\item{title}{A character string containing the text to display.}

\item{text}{Descriptive text.}

\item{count}{A logical value indicating whether to include a count in the text.}

\item{output_file}{A character string specifying the json file should be created.
If not provided, the template will be copied to the current working directory.}
}
\value{
A character string containing the HTML span element with the specified ID and text.
}
\description{
This function generates custom text and provides the option to include an
optional count that can be integrated into the text. It creates an HTML
span element with a unique identifier (ID). This identifier can be used for
customizing the appearance of the text using CSS code. Default identifiers are "text_issue", "text_inspect", "text_mod".
To use it, simply call the function within inline code, do not call this function within a chunk.
}
\examples{
if (interactive()) {
  # In RMarkdown, use 'r txt()`.
  # Do not call this function within a chunk

  txt("text_issue", "Issue", text = "Wrong participant number")
  txt("text_mod", "Modification", text = "Change the participant number from 1 to 32", 
      count = FALSE)
}

}
