% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_gengraph.R
\name{gengraph}
\alias{gengraph}
\title{A generic and extendable structure for decomposable graphical models}
\usage{
gengraph(df, type = "fwd", q = 0.5, sparse_qic = TRUE)
}
\arguments{
\item{df}{Character data.frame}

\item{type}{Character ("fwd", "bwd", "tree" or "tfwd")}

\item{q}{Penalty term in the stopping criterion
where \code{0} = AIC and \code{1} = BIC. Anything in between is
referred to as \code{qic}}

\item{sparse_qic}{Logical. If \code{nrow(df)} is small, the tables
tends to be sparse. In these cases the usual penalty term of AIC and
BIC is often too restrictive. If \code{sparse_qic} is \code{TRUE}
this penality is computed according to a sparse criteria. The criteria
resembles the usual penalty as \code{nrow(df)} grows.}
}
\value{
A \code{gengraph} object with child class \code{type} used for model selection.
}
\description{
A generic structure for decomposable graphical models
}
\examples{

gengraph(derma, type = "fwd")
gengraph(derma, type = "bwd")

}
\seealso{
\code{\link{adj_lst.gengraph}}, \code{\link{adj_mat.gengraph}}, \code{\link{fit_graph}}, \code{\link{walk.fwd}}, \code{\link{walk.bwd}}
}
