% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_gengraph.R
\name{walk}
\alias{walk}
\title{Stepwise model selection}
\usage{
walk(x, df, q, thres)
}
\arguments{
\item{x}{\code{fwd} or \code{bwd} objects}

\item{df}{data.frame}

\item{q}{Penalty term in the stopping criterion  (\code{0} = AIC and \code{1} = BIC)}

\item{thres}{A threshold mechanism for choosing between two different ways of calculating the entropy. Can Speed up the procedure with the "correct" value.}
}
\value{
A \code{fwd} or \code{bwd} object with one additional edge than the input object.
}
\description{
Stepwise model selection in decomposable graphical models
}
\details{
A \code{fwd} (or \code{bwd}) object can be created using the \code{gengraph} constructor with \code{type = "fwd"}.
}
\examples{

d <- derma[, 10:25]

g <- gengraph(d, type = "fwd")
s <- walk(g, d)
print(s)
plot(s)
adj_lst(s)
adj_mat(s)

}
\seealso{
\code{\link{fit_graph}}, \code{\link{walk.fwd}}, \code{\link{gengraph}}
}
