% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_samplers.R
\docType{class}
\name{rho_sampler}
\alias{rho_sampler}
\title{An R6 class for sampling the spatial autoregressive parameter \eqn{\rho}}
\format{
An \code{\link[R6]{R6Class}} generator object
}
\description{
An R6 class for sampling the spatial autoregressive parameter \eqn{\rho}

An R6 class for sampling the spatial autoregressive parameter \eqn{\rho}
}
\details{
This class samples the spatial autoregressive parameter using either a tuned random-walk
Metropolis-Hastings or a griddy Gibbs step. Use the \code{\link{rho_priors}} class for setup.

For the griddy Gibbs algorithm see Ritter and Tanner (1992).
}
\references{
Ritter, C., and Tanner, M. A. (1992). Facilitating the Gibbs sampler: The Gibbs stopper
 and the griddy-Gibbs sampler. \emph{Journal of the American Statistical Association},
 \bold{87(419)}, 861-868.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rho_prior}}{The current \code{\link{rho_priors}}}

\item{\code{curr_rho}}{The current value of \eqn{\rho}}

\item{\code{curr_W}}{The current spatial weight matrix \eqn{W}; an \eqn{n} by \eqn{n} matrix.}

\item{\code{curr_A}}{The current spatial filter matrix \eqn{I - \rho W}.}

\item{\code{curr_AI}}{The inverse of \code{curr_A}}

\item{\code{curr_logdet}}{The current log-determinant of \code{curr_A}}

\item{\code{curr_logdets}}{A set of log-determinants for various values of \eqn{\rho}. See the
\code{\link{rho_priors}} function for settings of step site and other parameters of the grid.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rho_sampler-new}{\code{rho_sampler$new()}}
\item \href{#method-rho_sampler-stopMHtune}{\code{rho_sampler$stopMHtune()}}
\item \href{#method-rho_sampler-setW}{\code{rho_sampler$setW()}}
\item \href{#method-rho_sampler-sample}{\code{rho_sampler$sample()}}
\item \href{#method-rho_sampler-sample_Griddy}{\code{rho_sampler$sample_Griddy()}}
\item \href{#method-rho_sampler-sample_MH}{\code{rho_sampler$sample_MH()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$new(rho_prior, W = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rho_prior}}{The list returned by \code{\link{rho_priors}}}

\item{\code{W}}{An optional starting value for the spatial weight matrix \eqn{W}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-stopMHtune"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-stopMHtune}{}}}
\subsection{Method \code{stopMHtune()}}{
Function to stop the tuning of the Metropolis-Hastings step. The tuning of the
Metropolis-Hastings step is usually carried out until half of the burn-in phase.
Call this function to turn it off.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$stopMHtune()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-setW"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-setW}{}}}
\subsection{Method \code{setW()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$setW(newW, newLogdet = NULL, newA = NULL, newAI = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newW}}{The updated spatial weight matrix \eqn{W}.}

\item{\code{newLogdet}}{An optional value for the log determinant corresponding to \code{newW} and \code{curr_rho}.}

\item{\code{newA}}{An optional value for the spatial projection matrix using \code{newW} and \code{curr_rho}.}

\item{\code{newAI}}{An optional value for the matrix inverse of \code{newA}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-sample"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-sample}{}}}
\subsection{Method \code{sample()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$sample(Y, mu, sigma)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{The \eqn{n} by \eqn{T} matrix of responses.}

\item{\code{mu}}{The \eqn{n} by \eqn{T} matrix of means.}

\item{\code{sigma}}{The variance parameter \eqn{\sigma^2}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-sample_Griddy"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-sample_Griddy}{}}}
\subsection{Method \code{sample_Griddy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$sample_Griddy(Y, mu, sigma)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{The \eqn{n} by \eqn{T} matrix of responses.}

\item{\code{mu}}{The \eqn{n} by \eqn{T} matrix of means.}

\item{\code{sigma}}{The variance parameter \eqn{\sigma^2}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rho_sampler-sample_MH"></a>}}
\if{latex}{\out{\hypertarget{method-rho_sampler-sample_MH}{}}}
\subsection{Method \code{sample_MH()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rho_sampler$sample_MH(Y, mu, sigma)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{The \eqn{n} by \eqn{T} matrix of responses.}

\item{\code{mu}}{The \eqn{n} by \eqn{T} matrix of means.}

\item{\code{sigma}}{The variance parameter \eqn{\sigma^2}.}
}
\if{html}{\out{</div>}}
}
}
}
