% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-competition-aheadbehind.R
\name{getCompetitionAheadBehind}
\alias{getCompetitionAheadBehind}
\title{Get competition ahead-behind standings}
\usage{
getCompetitionAheadBehind(season_code, round)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}
}
\value{
Returns a summary tibble of ahead-behind for chosen competition and round

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/standings/?season=2023-24&type=Ahead\%20behind&phase=REGULAR\%20SEASON}{Ahead-behind standings}
}
\description{
Get competition ahead-behind standings
}
\examples{

\dontrun{

getCompetitionAheadBehind(season_code = c("E2023", "E2022"), round = 1)

}

}
\keyword{`r}
\keyword{competitionStandings}
\keyword{lifecycle::badge('experimental')`}
