% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eurotime2date.R
\name{eurotime2date}
\alias{eurotime2date}
\title{Date Conversion from New Eurostat Time Format}
\usage{
eurotime2date(x, last = FALSE)
}
\arguments{
\item{x}{a charter string with time information in Eurostat time format.}

\item{last}{a logical. If \code{FALSE} (default) the date  is
the first date of the period (month, quarter or year). If \code{TRUE}
the date is the last date of the period.}
}
\value{
an object of class \code{\link[=Date]{Date()}}.
}
\description{
Date conversion from Eurostat time format. A function to
convert Eurostat time values to objects of class \code{\link[=Date]{Date()}}
representing calendar dates.
}
\details{
Available patterns are YYYY (year), YYYY-SN (semester), YYYY-QN (quarter),
YYYY-MM (month), YYYY-WNN (week) and YYYY-MM-DD (day).
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
na_q <- get_eurostat("namq_10_pc", time_format = "raw")
na_q$TIME_PERIOD <- eurotime2date(x = na_q$TIME_PERIOD)
unique(na_q$TIME_PERIOD)
}

\dontrun{
# Test for weekly data
get_eurostat(
  id = "lfsi_abs_w",
  select_time = c("W"),
  time_format = "date"
  )
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Kindly cite the eurostat R package as follows:
# 
#   Lahti L., Huovari J., Kainu M., and Biecek P. (2017). Retrieval and
#   analysis of Eurostat open data with the eurostat package. The R
#   Journal 9(1), pp. 385-392. doi: 10.32614/RJ-2017-019
# 
#   Lahti, L., Huovari J., Kainu M., Biecek P., Hernangomez D., Antal D.,
#   and Kantanen P. (2023). eurostat: Tools for Eurostat Open Data
#   [Computer software]. R package version 4.0.0.
#   https://github.com/rOpenGov/eurostat
# 
# To see these entries in BibTeX format, use 'print(<citation>,
# bibtex=TRUE)', 'toBibtex(.)', or set
# 'options(citation.bibtex.max=999)'.
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[lubridate:ymd]{lubridate::ymd()}}

Other helpers: 
\code{\link{cut_to_classes}()},
\code{\link{dic_order}()},
\code{\link{eurotime2num}()},
\code{\link{harmonize_country_code}()},
\code{\link{label_eurostat}()}
}
\author{
Janne Huovari \href{mailto:janne.huovari@ptt.fi}{janne.huovari@ptt.fi}
}
\concept{helpers}
