% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_overlay.R
\name{overlay}
\alias{overlay}
\title{Plot or add points using a color scale}
\usage{
overlay(
  p,
  z,
  col,
  col2,
  lim = range(z, na.rm = TRUE),
  symmetry = TRUE,
  pch = 19,
  pch2 = 1,
  cex = 1,
  cex2 = 1.2 * cex,
  outside = TRUE,
  add = FALSE,
  plg = list(tic = "none", shrink = 1),
  pax = list(),
  expand = 1.15,
  ...
)
}
\arguments{
\item{p}{SpatVector points}

\item{z}{column name or a vector of values to plot}

\item{col}{color for the point}

\item{col2}{color for the outline}

\item{lim}{range of values for scale}

\item{symmetry}{calculate symmetrical scale}

\item{pch}{type of point}

\item{pch2}{type of point for contour}

\item{cex}{character expansion for the points}

\item{cex2}{character expansion for the contour}

\item{outside}{to include values outside range}

\item{add}{add to existing plot}

\item{plg}{list of parameters passed to terra::add_legend}

\item{pax}{list of parameters passed to graphics::axis}

\item{expand}{to expand the plot region}

\item{...}{arguments to be passing to terra::plot}
}
\value{
No return value
}
\description{
Custon plot for SpatRaster (terra R-package) object based on terra package
}
\examples{
sp<- terra::vect(paste0(system.file("extdata",package="eva3dm"),"/masp.shp"))
BR<- terra::vect(paste0(system.file("extdata",package="eva3dm"),"/BR.shp"))

p    <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/sites_AQ_BR.Rds"))
p$id      <- row.names(p)
point     <- terra::vect(p)
point$NMB <- 1:45 - 20 # some values to plot

terra::plot(BR, main = 'add points',xlim = c(-52,-37),ylim = c(-25,-18))
terra::lines(BR)
terra::lines(sp, col = 'gray')
overlay(point,point$NMB,cex = 1.4, add = TRUE)

overlay(point,point$NMB,cex = 1.4, add = FALSE, main = 'new plot')
terra::lines(BR)
terra::lines(sp, col = 'gray')

}
