% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countSeqDiffs.R
\name{countSeqDiffs}
\alias{countSeqDiffs}
\title{Counting protein sequence differences}
\usage{
countSeqDiffs(x, taxon1, taxon2)
}
\arguments{
\item{x}{A "ProteinSeq" object containing proteins from \code{taxon1}
and \code{taxon2}.}

\item{taxon1}{A character giving the common name of the first species that
will be compared. Must be a name present in \code{x}.}

\item{taxon2}{A character giving the common name of the second species that
will be compared. Must be a name present in \code{x}.}
}
\value{
A integer giving the number of protein differences between
\code{taxon1} and \code{taxon2}.
}
\description{
\code{countSeqDiffs} counts the number of protein differences among two sequences of proteins within the same "ProteinSeq" object.
}
\examples{
countSeqDiffs(cytOxidase, "human", "chimpanzee")

countSeqDiffs(cytOxidase, "human", "cnidaria")

countSeqDiffs(cytOxidase, "chimpanzee", "cnidaria")

}
\author{
Matheus Januario, Dan Rabosky, Jennifer Auler
}
