% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{plot_energy_models}
\alias{plot_energy_models}
\title{Compare density of estimated energy with density of real energy vector}
\usage{
plot_energy_models(energy_models, nrow = 2)
}
\arguments{
\item{energy_models}{energy models returned by function \code{get_energy_models}}

\item{nrow}{integer, number of rows in the plot grid (passed to \code{cowplot::plot_grid})}
}
\value{
ggplot
}
\description{
Compare density of estimated energy with density of real energy vector
}
\examples{
# The package evprof provides example objects of connection and energy
# Gaussian Mixture Models obtained from California's open data set
# (see California article in package website) created with functions
# `get_connection models` and `get_energy models`.

# Get the working days energy models
energy_models <- evprof::california_GMM$workdays$energy_models

# Plot energy models
plot_energy_models(energy_models)


}
