% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{mark_resolution}
\alias{mark_resolution}
\title{Mark unacceptable screen resolution}
\usage{
mark_resolution(
  x,
  res_min = 1000,
  width_min = 0,
  height_min = 0,
  id_col = "ResponseId",
  res_col = "Resolution",
  rename = TRUE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{res_min}{Minimum acceptable screen resolution (width and height).}

\item{width_min}{Minimum acceptable screen width.}

\item{height_min}{Minimum acceptable screen height.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{res_col}{Column name for screen resolution (in format widthxheight).}

\item{rename}{Logical indicating whether to rename columns (using \code{\link[=rename_columns]{rename_columns()}})}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes a column marking rows
that have unacceptable screen resolutions.
For a function that checks for these rows, use \code{\link[=check_resolution]{check_resolution()}}.
For a function that excludes these rows, use \code{\link[=exclude_resolution]{exclude_resolution()}}.
}
\description{
The \code{mark_resolution()} function creates a column labeling
rows that have unacceptable screen resolution.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
To record this information in your Qualtrics survey, you must
\href{https://www.qualtrics.com/support/survey-platform/survey-module/editing-questions/question-types-guide/advanced/meta-info-question/}{insert a meta info question}.

Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.

The function outputs to console a message about the number of rows
with unacceptable screen resolution.
}
\examples{
# Mark low screen resolutions
data(qualtrics_text)
df <- mark_resolution(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  mark_resolution()
}
\seealso{
Other resolution functions: 
\code{\link{check_resolution}()},
\code{\link{exclude_resolution}()}

Other mark functions: 
\code{\link{mark_duplicates}()},
\code{\link{mark_duration}()},
\code{\link{mark_ip}()},
\code{\link{mark_location}()},
\code{\link{mark_preview}()},
\code{\link{mark_progress}()}
}
\concept{mark functions}
\concept{resolution functions}
