% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallized_tests.R
\name{parallized_tests}
\alias{parallized_tests}
\title{conducts and controls the parallelisation of the tests, Intentionally,
 there are no defauklt values for the parameters, as this internal
  function is called by \link{exhaustive_tests} that also defines the
   default values for this function.}
\usage{
parallized_tests(
  dset,
  modelType,
  combos,
  models,
  p.par,
  na.rm,
  testfunction,
  itemfit_param,
  splitcr = NULL,
  icat_wald,
  alpha,
  bonf,
  DIFvars,
  gap_prop,
  max_contrast,
  PSI,
  extremes,
  ignoreCores,
  estimation_param,
  tests_count,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dset}{a data.frame containing the data}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: RM, PCM, RSM}

\item{combos}{either 1) a list of item combinations to be tested, e.g.
from \link{apply_combo_rules} or the passed_combos slot of an object
 of \link{passed_exRa-class} from a previous call to this function.
  Or 2) an object of \link{passed_exRa-class}. In this case, the
   previously fit models froms its passed_Models slot will also be used
    and will be passed to the test functions. This will speed up the
     analysis. If the parameter is NULL, all possible combinations of
      the items (columns) in dset will be tested}

\item{na.rm}{a boolean value. If TRUE, in the respective item combination
all cases with any NA are removed (na.omit). If FALSE, only cases with
 full NA responses are removed. NOTE: \link{test_mloef} currently does
  not allow for missing values (because erm::MLoef doesn't).
   If \link{test_mloef} is under the tests to perform, na.rm will
    automatically be set TRUE for ALL tests.}

\item{testfunction}{a character defining the actual test (the internal
testfunction) to perform. Possible values: all_rawscores, test_itemfit,
 test_LR, test_mloef, test_waldtest, threshold_order, test_DIFtree,
  test_personsItems, test_respca.}

\item{itemfit_param}{a list from \link{itemfit_control} with options
for \link{test_itemfit}}

\item{splitcr}{the split criterion to use, if the actual testfunction
is test_LR or test_waldtest.Split criterion for subject raw score
 splitting. "all.r" corresponds to a full raw score split, "median"
  uses the median as split criterion, "mean" performs a mean split.
   Optionally splitcr can also be a vector which assigns each person
    to a certain subgroup (e.g., following an external criterion).
     This vector can be numeric, character or a factor.}

\item{icat_wald}{a boolean value indicating if the waldtest will be
conducted on item level (TRUE, default value) or on item category level.
This parameter only effects estimations using psychotools or pairwise and
will be ignored for eRm estimations.}

\item{alpha}{a numeric value for the alpha level. Will be ignored for
\link{test_itemfit} if use.pval in \link{itemfit_control} is FALSE}

\item{bonf}{a boolean value wheter to use a Bonferroni correction.
Will be ignored if use.pval is FALSE}

\item{DIFvars}{a data.frame containing the variables and their data to use
for differential item functioning analysis with \link{test_DIFtree}}

\item{gap_prop}{a numeric value between 0 and 1 that sets the criterion
for the minimum proportion of neighboring person parameters with an
 item/threshold location in between. If set to 0, this criterion will not
  be checked (used in test_personsItems only)}

\item{max_contrast}{a numeric value defining the maximum loading of a
factor in the principal components analysis of the standardised residuals.
Only relevant, if test_respca is one of the tests.}

\item{extremes}{a boolean value indicating if a check for the
item/threshold locations left of the 2nd lowest and right of the
 2nd highest person parameter (used in test_personsItems only).}

\item{ignoreCores}{a numeric value for the number of cpu cores to hold out
in parallelizing the test run.}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}

\item{verbose}{a boolean value. If set to FALSE, all output during the
analysis will be suppressed.}

\item{...}{options for \link{itemfit_control} can be passed directly
to this function.}
}
\value{
a list containing 3 elements is returned: a list of the item
 combinations, a list of the models (depending on modelType and
 estimation_param$est) with the fit models and a list with the person
 parameter objects (depending on estimation_param$est).
}
\description{
conducts and controls the parallelisation of the tests, Intentionally,
 there are no defauklt values for the parameters, as this internal
  function is called by \link{exhaustive_tests} that also defines the
   default values for this function.
}
\keyword{internal}
