% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaR.R
\name{VaR}
\alias{VaR}
\alias{VaR.evmm}
\title{Value-at-Risk}
\usage{
VaR(x, ...)

\method{VaR}{evmm}(x, values = NULL, cred = 0.95, ...)
}
\arguments{
\item{x}{the output of a model estimated with \code{extrememix}}

\item{...}{additional arguments for compatibility.}

\item{values}{numeric vector of values of which to compute the value at risk.}

\item{cred}{amplitude of the posterior credibility interval.}
}
\value{
A list with the following entries: \itemize{
\item \code{quantiles}: a matrix containing the estimated value at risk, the posterior credibility intervals and the empirical estimate.
\item \code{data}: the dataset used to estimate the value at risk.
\item \code{complete}: a matrix with the value at risk for each value in the posterior sample.
}
}
\description{
Computation of the Value-at-Risk for an extreme value mixture model.
}
\details{
The Value-at-Risk for level q\\% is defined as the 1-q/100 quantile of the model.
}
\examples{
VaR(rainfall_ggpd)
}
\references{
Lattanzi, Chiara, and Manuele Leonelli. "A changepoint approach for the identification of financial extreme regimes." Brazilian Journal of Probability and Statistics.
}
\seealso{
\code{\link{ES}}, \code{\link{quant}}, \code{\link{return_level}}
}
