% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amd2}
\alias{amd2}
\title{Real life data of patients with neovascular AMD}
\format{
A data frame (tibble) with 40764 rows and 7 variables:
\describe{
\item{patID}{Anonymized patient identifier}
\item{sex}{Sex of patient (m = male, f = female)}
\item{age0}{Age (years) at day of first appointment}
\item{eye}{Left or right eye of patient (r = right, l = left)}
\item{time}{Time in days after date of first appointment (0 = first appointment)}
\item{va}{Visual acuity in Early Treatment Diabetic Retinopathy Study letters}
\item{inj_no}{Current number of injection at appointment date}
}
}
\source{
\url{https://doi.org/10.5061/dryad.97r9289}
}
\usage{
data("amd2")
}
\description{
A dataset containing anonymized real life human subjects data on eyes with
treatment naive neovascular age-related macular degeneration (AMD),
which underwent intravitreal anti-VEGF therapy with ranibizumab
and/or aflibercept.
}
\details{
The data was collected in Moorfields Eye Hospital, London, UK.
(Information governance sign off Moorfields Eye Hospital 19/07/2018)

Data was accessed on the 25th May 2020
}
\section{Missing values}{

There are two missing visual acuity entries in this data set. They result
from data entry errors (ETDRS values above 100) in the original
medical health records. Unfortunately, the correct VA value could not be
retrieved and it was decided to assign missing values to those measurements.
}

\seealso{
Scientific article to which this data set was supplement:
\url{https://doi.org/10.1136/bmjopen-2018-027441}
}
\keyword{datasets}
